/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriverEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DisconnectingInputShop;
import de.schlichtherle.truezip.socket.DisconnectingOutputShop;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.socket.ThrowingInputShop;
import de.schlichtherle.truezip.socket.ThrowingOutputShop;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import de.schlichtherle.truezip.util.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MockArchiveDriverEntryContainer
implements EntryContainer<MockArchiveDriverEntry> {
    final Map<String, MockArchiveDriverEntry> entries;
    private final TestConfig config;
    @CheckForNull
    private ThrowControl control;

    public static MockArchiveDriverEntryContainer create(@CheckForNull TestConfig config) {
        if (null == config) {
            config = TestConfig.get();
        }
        return new MockArchiveDriverEntryContainer(new LinkedHashMap<String, MockArchiveDriverEntry>(Maps.initialCapacity((int)config.getNumEntries())), config);
    }

    private MockArchiveDriverEntryContainer(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
        this.entries = entries;
        this.config = config;
    }

    private ThrowControl getThrowControl() {
        ThrowControl control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkUndeclaredExceptions() {
        this.getThrowControl().check(this, RuntimeException.class);
        this.getThrowControl().check(this, Error.class);
    }

    private IOPoolProvider getIOPoolProvider() {
        return this.config.getIOPoolProvider();
    }

    final IOPool<?> getIOPool() {
        return this.getIOPoolProvider().get();
    }

    public int getSize() {
        this.checkUndeclaredExceptions();
        return this.entries.size();
    }

    public Iterator<MockArchiveDriverEntry> iterator() {
        this.checkUndeclaredExceptions();
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public MockArchiveDriverEntry getEntry(String name) {
        this.checkUndeclaredExceptions();
        return this.entries.get(name);
    }

    public InputShop<MockArchiveDriverEntry> newInputShop() {
        this.checkUndeclaredExceptions();
        return new ThrowingInputShop(new DisconnectingInputShop((InputShop)new MockInputShop(this.entries, this.config)), this.config);
    }

    public OutputShop<MockArchiveDriverEntry> newOutputShop() {
        this.checkUndeclaredExceptions();
        return new ThrowingOutputShop(new DisconnectingOutputShop((OutputShop)new MockOutputShop(this.entries, this.config)), this.config);
    }

    private static final class MockOutputShop
    extends MockArchiveDriverEntryContainer
    implements OutputShop<MockArchiveDriverEntry> {
        MockOutputShop(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
            super(entries, config);
        }

        public OutputSocket<? extends MockArchiveDriverEntry> getOutputSocket(final MockArchiveDriverEntry entry) {
            if (null == entry) {
                throw new NullPointerException();
            }
            class Output
            extends OutputSocket<MockArchiveDriverEntry> {
                Output() {
                }

                public MockArchiveDriverEntry getLocalTarget() {
                    return entry;
                }

                public SeekableByteChannel newSeekableByteChannel() throws IOException {
                    return this.getBufferOutputSocket().newSeekableByteChannel();
                }

                public OutputStream newOutputStream() throws IOException {
                    class MockOutputStream
                    extends DecoratingOutputStream {
                        MockOutputStream() throws IOException {
                            super(this.getBufferOutputSocket().newOutputStream());
                        }

                        public void close() throws IOException {
                            this.delegate.close();
                            this.copyProperties();
                        }
                    }
                    return new MockOutputStream();
                }

                OutputSocket<? extends IOEntry<?>> getBufferOutputSocket() throws IOException {
                    MockOutputShop.this.entries.put(entry.getName(), entry);
                    return this.getLocalTarget().getBuffer(MockOutputShop.this.getIOPool()).getOutputSocket();
                }

                void copyProperties() {
                    IOPool.Entry<?> src;
                    MockArchiveDriverEntry dst = this.getLocalTarget();
                    try {
                        src = dst.getBuffer(MockOutputShop.this.getIOPool());
                    }
                    catch (IOException ex) {
                        throw new AssertionError((Object)ex);
                    }
                    for (Entry.Size type : Entry.ALL_SIZE_SET) {
                        dst.setSize(type, src.getSize(type));
                    }
                    for (Entry.Size type : Entry.ALL_ACCESS_SET) {
                        dst.setTime((Entry.Access)type, src.getTime((Entry.Access)type));
                    }
                }
            }
            return new Output();
        }

        public void close() {
        }
    }

    private static final class MockInputShop
    extends MockArchiveDriverEntryContainer
    implements InputShop<MockArchiveDriverEntry> {
        MockInputShop(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
            super(entries, config);
        }

        public InputSocket<? extends MockArchiveDriverEntry> getInputSocket(final String name) {
            if (null == name) {
                throw new NullPointerException();
            }
            class Input
            extends InputSocket<MockArchiveDriverEntry> {
                Input() {
                }

                public MockArchiveDriverEntry getLocalTarget() throws IOException {
                    MockArchiveDriverEntry entry = (MockArchiveDriverEntry)MockInputShop.this.entries.get(name);
                    if (null == entry) {
                        throw new FileNotFoundException(name + " (entry not found)");
                    }
                    return entry;
                }

                public SeekableByteChannel newSeekableByteChannel() throws IOException {
                    return this.getBufferInputSocket().newSeekableByteChannel();
                }

                public ReadOnlyFile newReadOnlyFile() throws IOException {
                    return this.getBufferInputSocket().newReadOnlyFile();
                }

                public InputStream newInputStream() throws IOException {
                    return this.getBufferInputSocket().newInputStream();
                }

                InputSocket<? extends IOEntry<?>> getBufferInputSocket() throws IOException {
                    return this.getLocalTarget().getBuffer(MockInputShop.this.getIOPool()).getInputSocket();
                }
            }
            return new Input();
        }

        public void close() {
        }
    }
}

