/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.io.ThrowingInputStream;
import de.schlichtherle.truezip.io.ThrowingOutputStream;
import de.schlichtherle.truezip.io.ThrowingSeekableByteChannel;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ThrowingReadOnlyFile;
import de.schlichtherle.truezip.socket.ByteArrayIOBuffer;
import de.schlichtherle.truezip.socket.DelegatingInputSocket;
import de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.Icon;

@ThreadSafe
public class MockController
extends FsController<FsModel> {
    private final FsModel model;
    @Nullable
    private final FsController<?> parent;
    private final ConcurrentMap<FsEntryName, IOEntry<?>> map = new ConcurrentHashMap();
    private final TestConfig config;
    @CheckForNull
    private volatile ThrowControl control;

    public MockController(FsModel model, @CheckForNull FsController<?> parent) {
        this(model, parent, null);
    }

    public MockController(FsModel model, @CheckForNull FsController<?> parent, @CheckForNull TestConfig config) {
        assert (null != model.getParent() ? model.getParent().equals((Object)parent.getModel()) : null == parent);
        this.model = model;
        this.parent = parent;
        this.config = null != config ? config : TestConfig.get();
    }

    private ThrowControl getThrowControl() {
        ThrowControl control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkAllExceptions(Object thiz) throws IOException {
        this.getThrowControl().check(thiz, IOException.class);
        this.checkUndeclaredExceptions((Object)this);
    }

    private void checkUndeclaredExceptions(Object thiz) {
        this.getThrowControl().check(thiz, RuntimeException.class);
        this.getThrowControl().check(thiz, Error.class);
    }

    public FsModel getModel() {
        this.checkUndeclaredExceptions((Object)this);
        return this.model;
    }

    public FsController<?> getParent() {
        this.checkUndeclaredExceptions((Object)this);
        return this.parent;
    }

    @Deprecated
    public Icon getOpenIcon() throws IOException {
        this.checkAllExceptions((Object)this);
        return null;
    }

    @Deprecated
    public Icon getClosedIcon() throws IOException {
        this.checkAllExceptions((Object)this);
        return null;
    }

    public boolean isReadOnly() throws IOException {
        this.checkAllExceptions((Object)this);
        return false;
    }

    public FsEntry getEntry(FsEntryName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public boolean isReadable(FsEntryName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(FsEntryName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public boolean isExecutable(FsEntryName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(FsEntryName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != times);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != types);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public InputSocket<?> getInputSocket(final FsEntryName name, BitField<FsInputOption> options) {
        this.checkUndeclaredExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        class Input
        extends DelegatingInputSocket<Entry> {
            Input() {
            }

            protected InputSocket<? extends Entry> getDelegate() throws IOException {
                MockController.this.checkAllExceptions((Object)this);
                IOEntry buffer = (IOEntry)MockController.this.map.get(name);
                if (null == buffer) {
                    throw new FileNotFoundException(name.toString());
                }
                return buffer.getInputSocket();
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return new ThrowingReadOnlyFile(this.getBoundSocket().newReadOnlyFile(), MockController.this.config.getThrowControl());
            }

            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return new ThrowingSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel(), MockController.this.config.getThrowControl());
            }

            public InputStream newInputStream() throws IOException {
                return new ThrowingInputStream(this.getBoundSocket().newInputStream(), MockController.this.config.getThrowControl());
            }
        }
        return new Input();
    }

    public OutputSocket<?> getOutputSocket(final FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        this.checkUndeclaredExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        class Output
        extends DelegatingOutputSocket<Entry> {
            Output() {
            }

            protected OutputSocket<? extends Entry> getDelegate() throws IOException {
                MockController.this.checkAllExceptions((Object)this);
                ByteArrayIOBuffer n = new ByteArrayIOBuffer(name.toString(), MockController.this.config.getDataSize());
                IOEntry o = (IOEntry)MockController.this.map.get(name);
                if (null == o) {
                    o = MockController.this.map.putIfAbsent(name, n);
                }
                return (null != o ? o : n).getOutputSocket();
            }

            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return new ThrowingSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel(), MockController.this.config.getThrowControl());
            }

            public OutputStream newOutputStream() throws IOException {
                return new ThrowingOutputStream(this.getBoundSocket().newOutputStream(), MockController.this.config.getThrowControl());
            }
        }
        return new Output();
    }

    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != type);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != options);
        assert (null != handler);
    }
}

