/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.io.ThrowingInputStream;
import de.schlichtherle.truezip.io.ThrowingOutputStream;
import de.schlichtherle.truezip.socket.ByteArrayIOBuffer;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import de.schlichtherle.truezip.util.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsTest {
    private static final int BUFFER_SIZE = 65536;
    private static final Random rnd = new Random();
    private ByteArrayIOBuffer buffer;

    @Before
    public void setUp() {
        TestConfig.push();
        this.buffer = StreamsTest.newByteArrayIOBuffer();
    }

    @After
    public void tearDown() {
        TestConfig.pop();
    }

    private static ByteArrayIOBuffer newByteArrayIOBuffer() {
        byte[] data = new byte[65536];
        rnd.nextBytes(data);
        return new ByteArrayIOBuffer("test", data);
    }

    private static TestInputStream newTestInputStream(ByteArrayIOBuffer buffer) throws IOException {
        return new TestInputStream(buffer.getInputSocket().newInputStream());
    }

    private static TestOutputStream newTestOutputStream(ByteArrayIOBuffer buffer) throws IOException {
        return new TestOutputStream(buffer.getOutputSocket().newOutputStream());
    }

    @Test
    public void testCat() throws IOException {
        new CatTest(){

            @Override
            void cat(TestInputStream in, TestOutputStream out) throws IOException {
                Streams.cat((InputStream)((Object)in), (OutputStream)((Object)out));
                Streams.cat((InputStream)((Object)in), (OutputStream)((Object)out));
            }
        }.run();
    }

    @Test
    public void testCatInputException() throws IOException {
        this.assertCatInputException(new IOException());
        this.assertCatInputException(new RuntimeException());
        this.assertCatInputException(new Error());
    }

    private void assertCatInputException(final Throwable expected) throws IOException {
        new CatTest(){

            @Override
            void cat(TestInputStream in, TestOutputStream out) throws IOException {
                block6: {
                    ThrowControl control = TestConfig.get().getThrowControl();
                    control.trigger(ThrowingInputStream.class, expected);
                    ThrowingInputStream tis = new ThrowingInputStream((InputStream)((Object)in), control);
                    try {
                        Streams.cat((InputStream)((Object)tis), (OutputStream)((Object)out));
                        Assert.fail();
                    }
                    catch (IOException got) {
                        if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                            throw got;
                        }
                    }
                    catch (RuntimeException got) {
                        if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                            throw got;
                        }
                    }
                    catch (Error got) {
                        if (Throwables.contains((Throwable)got, (Throwable)expected)) break block6;
                        throw got;
                    }
                }
                Streams.cat((InputStream)((Object)in), (OutputStream)((Object)out));
            }
        }.run();
    }

    @Test
    public void testCatOutputException() throws IOException {
        this.assertCatOutputException(new IOException());
        this.assertCatOutputException(new RuntimeException());
        this.assertCatOutputException(new Error());
    }

    private void assertCatOutputException(final Throwable expected) throws IOException {
        new CatTest(){

            @Override
            void cat(TestInputStream in, TestOutputStream out) throws IOException {
                block6: {
                    ThrowControl control = TestConfig.get().getThrowControl();
                    control.trigger(ThrowingOutputStream.class, expected);
                    ThrowingOutputStream tos = new ThrowingOutputStream((OutputStream)((Object)out));
                    Streams.cat((InputStream)((Object)in), (OutputStream)((Object)out));
                    try {
                        Streams.cat((InputStream)((Object)in), (OutputStream)((Object)tos));
                        Assert.fail();
                    }
                    catch (IOException got) {
                        if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                            throw got;
                        }
                    }
                    catch (RuntimeException got) {
                        if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                            throw got;
                        }
                    }
                    catch (Error got) {
                        if (Throwables.contains((Throwable)got, (Throwable)expected)) break block6;
                        throw got;
                    }
                }
            }
        }.run();
    }

    @Test
    public void testCopy() throws IOException {
        this.assertCopy(this.buffer);
    }

    private void assertCopy(ByteArrayIOBuffer buffer) throws IOException {
        byte[] data = buffer.getData();
        TestInputStream in = StreamsTest.newTestInputStream(buffer);
        TestOutputStream out = StreamsTest.newTestOutputStream(buffer);
        Thread.currentThread().interrupt();
        Streams.copy((InputStream)((Object)in), (OutputStream)((Object)out));
        Assert.assertTrue((boolean)Thread.interrupted());
        Assert.assertTrue((boolean)out.flushed);
        Assert.assertTrue((boolean)out.closed);
        Assert.assertTrue((boolean)in.closed);
        Assert.assertNotSame((Object)data, (Object)buffer.getData());
        Assert.assertArrayEquals((byte[])data, (byte[])buffer.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedCopying() throws Exception {
        int numThreads = Runtime.getRuntime().availableProcessors() * 10;
        int numTasks = 10 * numThreads;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(numTasks);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            for (int i = 0; i < numTasks; ++i) {
                class Task
                implements Callable<Void> {
                    Task() {
                    }

                    @Override
                    public Void call() throws IOException {
                        StreamsTest.this.assertCopy(StreamsTest.newByteArrayIOBuffer());
                        return null;
                    }
                }
                results.add(executor.submit(new Task()));
            }
        }
        finally {
            executor.shutdown();
        }
        for (Future future : results) {
            future.get();
        }
    }

    private static class TestOutputStream
    extends DecoratingOutputStream {
        boolean flushed;
        boolean closed;

        TestOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            throw new AssertionError();
        }

        public void flush() throws IOException {
            this.delegate.flush();
            this.flushed = true;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }
    }

    private static class TestInputStream
    extends DecoratingInputStream {
        boolean closed;

        TestInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            throw new AssertionError();
        }

        public long skip(long n) throws IOException {
            throw new AssertionError();
        }

        public int available() throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }

        public void mark(int readlimit) {
            throw new AssertionError();
        }

        public void reset() throws IOException {
            throw new AssertionError();
        }

        public boolean markSupported() {
            throw new AssertionError();
        }
    }

    private static abstract class CatTest {
        final byte[] data = new byte[65536];
        final ByteArrayIOBuffer buffer;

        private CatTest() {
            rnd.nextBytes(this.data);
            this.buffer = new ByteArrayIOBuffer("test", this.data);
        }

        void run() throws IOException {
            TestInputStream in = StreamsTest.newTestInputStream(this.buffer);
            TestOutputStream out = StreamsTest.newTestOutputStream(this.buffer);
            Thread.currentThread().interrupt();
            this.cat(in, out);
            Assert.assertTrue((String)"The interrupt status should not have changed!", (boolean)Thread.interrupted());
            Assert.assertTrue((boolean)out.flushed);
            Assert.assertFalse((boolean)out.closed);
            Assert.assertFalse((boolean)in.closed);
            in.close();
            out.close();
            Assert.assertNotSame((Object)this.data, (Object)this.buffer.getData());
            Assert.assertArrayEquals((byte[])this.data, (byte[])this.buffer.getData());
        }

        abstract void cat(TestInputStream var1, TestOutputStream var2) throws IOException;
    }
}

