/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ThrowingSeekableByteChannel
extends DecoratingSeekableByteChannel {
    private final ThrowControl control;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel sbc) {
        this(sbc, null);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel sbc, @CheckForNull ThrowControl control) {
        super(sbc);
        if (null == sbc) {
            throw new NullPointerException();
        }
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public int read(ByteBuffer dst) throws IOException {
        this.checkAllExceptions();
        return this.delegate.read(dst);
    }

    public int write(ByteBuffer src) throws IOException {
        this.checkAllExceptions();
        return this.delegate.write(src);
    }

    public long position() throws IOException {
        this.checkAllExceptions();
        return this.delegate.position();
    }

    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkAllExceptions();
        this.delegate.position(newPosition);
        return this;
    }

    public long size() throws IOException {
        this.checkAllExceptions();
        return this.delegate.size();
    }

    public SeekableByteChannel truncate(long size) throws IOException {
        this.checkAllExceptions();
        this.delegate.truncate(size);
        return this;
    }

    public boolean isOpen() {
        this.checkUndeclaredExceptions();
        return this.delegate.isOpen();
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.delegate.close();
    }
}

