/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.ArrayHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ReadOnlyFileTestSuite {
    private static final Logger logger = Logger.getLogger(ReadOnlyFileTestSuite.class.getName());
    protected static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    protected static final byte[] DATA = new byte[1024];
    private File temp;
    private ReadOnlyFile rrof;
    private ReadOnlyFile trof;
    private byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws IOException {
        this.temp = File.createTempFile(TEMP_FILE_PREFIX, null);
        try {
            FileOutputStream out = new FileOutputStream(this.temp);
            try {
                ((OutputStream)out).write(DATA);
            }
            finally {
                ((OutputStream)out).close();
            }
            assert ((long)DATA.length == this.temp.length());
            this.rrof = new DefaultReadOnlyFile(this.temp);
            this.trof = this.newReadOnlyFile(this.temp);
        }
        catch (IOException ex) {
            if (!this.temp.delete()) {
                throw new IOException(this.temp + " (could not delete)", ex);
            }
            throw ex;
        }
        this.data = (byte[])DATA.clone();
    }

    protected abstract ReadOnlyFile newReadOnlyFile(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @After
    public void tearDown() {
        try {
            try {
                block8: {
                    ReadOnlyFile rrof;
                    try {
                        ReadOnlyFile trof = this.trof;
                        this.trof = null;
                        if (trof != null) {
                            trof.close();
                        }
                        rrof = this.rrof;
                        this.rrof = null;
                        if (rrof == null) break block8;
                    }
                    catch (Throwable throwable) {
                        ReadOnlyFile rrof2 = this.rrof;
                        this.rrof = null;
                        if (rrof2 == null) throw throwable;
                        rrof2.close();
                        throw throwable;
                    }
                    rrof.close();
                }
            }
            finally {
                if (!this.temp.exists()) return;
                if (this.temp.delete()) return;
                throw new IOException(this.temp + " (could not delete)");
            }
        }
        catch (IOException ex) {
            logger.log(Level.FINEST, "Failed to clean up test file (this may be just an aftermath):", ex);
        }
    }

    @Test
    public final void testClose() throws IOException {
        ReadOnlyFileTestSuite.close(this.rrof);
        ReadOnlyFileTestSuite.close(this.trof);
    }

    private static void close(ReadOnlyFile rof) throws IOException {
        rof.close();
        try {
            rof.length();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            rof.getFilePointer();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            rof.seek(0L);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            rof.read();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Assert.assertEquals((long)0L, (long)rof.read(new byte[0]));
        }
        catch (IOException mayHappen) {
            // empty catch block
        }
        try {
            rof.read(new byte[1]);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Assert.assertEquals((long)0L, (long)rof.read(new byte[0], 0, 0));
        }
        catch (IOException mayHappen) {
            // empty catch block
        }
        try {
            rof.read(new byte[1], 0, 1);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            rof.readFully(new byte[0]);
        }
        catch (IOException mayHappen) {
            // empty catch block
        }
        try {
            rof.readFully(new byte[1]);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            rof.readFully(new byte[0], 0, 0);
        }
        catch (IOException mayHappen) {
            // empty catch block
        }
        try {
            rof.readFully(new byte[1], 0, 1);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rof.close();
    }

    @Test
    public final void testLength() throws Exception {
        Assert.assertEquals((long)this.data.length, (long)this.rrof.length());
        Assert.assertEquals((long)this.data.length, (long)this.trof.length());
    }

    @Test
    public final void testForwardReadBytes() throws IOException {
        this.assertForwardReadBytes(this.rrof);
        this.assertForwardReadBytes(this.trof);
    }

    private void assertForwardReadBytes(ReadOnlyFile rof) throws IOException {
        long length = rof.length();
        int off = 0;
        while ((long)off < length) {
            Assert.assertEquals((long)(this.data[off] & 0xFF), (long)rof.read());
            ++off;
        }
        Assert.assertEquals((long)-1L, (long)rof.read());
    }

    @Test
    public final void testRandomReadBytes() throws IOException {
        this.assertRandomReadBytes(this.rrof);
        this.assertRandomReadBytes(this.trof);
    }

    private void assertRandomReadBytes(ReadOnlyFile rof) throws IOException {
        int length;
        Assert.assertEquals((long)0L, (long)rof.getFilePointer());
        this.assertRandomReadByte(rof, 0);
        int i = length = (int)rof.length();
        while (--i >= 0) {
            int tooSmall = rnd.nextInt() | Integer.MIN_VALUE;
            try {
                this.assertRandomReadByte(rof, tooSmall);
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
            int tooLarge = Math.max(length + 1, rnd.nextInt() & Integer.MAX_VALUE);
            try {
                this.assertRandomReadByte(rof, tooLarge);
            }
            catch (IOException mayHappen) {
                // empty catch block
            }
            int justRight = rnd.nextInt(length);
            this.assertRandomReadByte(rof, justRight);
        }
    }

    private void assertRandomReadByte(ReadOnlyFile rof, int off) throws IOException {
        rof.seek((long)off);
        Assert.assertEquals((long)off, (long)rof.getFilePointer());
        if ((long)off < rof.length()) {
            Assert.assertEquals((long)(this.data[off] & 0xFF), (long)rof.read());
            Assert.assertEquals((long)(off + 1), (long)rof.getFilePointer());
        } else {
            Assert.assertEquals((long)-1L, (long)rof.read());
            Assert.assertEquals((long)off, (long)rof.getFilePointer());
        }
    }

    @Test
    public final void testBackwardReadBytes() throws IOException {
        this.assertBackwardReadBytes(this.rrof);
        this.assertBackwardReadBytes(this.trof);
    }

    private void assertBackwardReadBytes(ReadOnlyFile rof) throws IOException {
        int length;
        int off = length = (int)rof.length();
        while (--off >= 0) {
            this.assertRandomReadByte(rof, off);
        }
    }

    @Test
    public final void testForwardReadChunks() throws IOException {
        byte[] buf;
        int read;
        int length = (int)this.rrof.length();
        int off = 0;
        while ((read = this.rrof.read(buf = new byte[rnd.nextInt(length / 100)])) >= 0) {
            if (buf.length > 0) {
                Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
                Arrays.fill(buf, (byte)0);
                this.trof.readFully(buf, 0, read);
                Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
            } else {
                Assert.assertTrue((read == 0 ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)this.trof.read(buf));
            }
            off += read;
        }
        Assert.assertEquals((long)off, (long)length);
        Assert.assertEquals((long)-1L, (long)read);
        Assert.assertEquals((long)-1L, (long)this.trof.read(new byte[1]));
        Assert.assertEquals((long)0L, (long)this.rrof.read(new byte[0]));
        Assert.assertEquals((long)0L, (long)this.trof.read(new byte[0]));
    }

    @Test
    public final void testRandomReadChunks() throws IOException {
        int length = (int)this.rrof.length();
        int i = 100;
        while (--i >= 0) {
            int off = rnd.nextInt(length);
            this.assertRandomReadByte(this.rrof, off);
            this.assertRandomReadByte(this.trof, off);
            ++off;
            byte[] buf = new byte[rnd.nextInt(length / 100)];
            int read = this.rrof.read(buf);
            if (read < 0) continue;
            if (buf.length > 0) {
                Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
                Arrays.fill(buf, (byte)0);
                this.trof.readFully(buf, 0, read);
                Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
                continue;
            }
            Assert.assertTrue((read == 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.trof.read(buf));
        }
    }

    static {
        rnd.nextBytes(DATA);
    }
}

