/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.Paths;
import java.io.CharConversionException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class FsCharsetArchiveDriver<E extends FsArchiveEntry>
extends FsArchiveDriver<E> {
    private final Charset charset;
    private final ThreadLocalCharsetEncoder encoder = new ThreadLocalCharsetEncoder();

    protected FsCharsetArchiveDriver(Charset charset) {
        this.charset = charset;
        if (null == this.charset) {
            throw new NullPointerException();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    protected static String toZipOrTarEntryName(String name, Entry.Type type) {
        return Entry.Type.DIRECTORY == type ? (name.endsWith("/") ? name : name + '/') : Paths.cutTrailingSeparators(name, '/');
    }

    @Override
    protected final void assertEncodable(String name) throws CharConversionException {
        if (!this.encoder.canEncode(name)) {
            throw new CharConversionException(name + " (cannot encode all characters to " + this.getCharset() + ")");
        }
    }

    @Override
    public String toString() {
        return String.format("%s[charset=%s, federated=%b, priority=%d]", this.getClass().getName(), this.getCharset(), this.isFederated(), this.getPriority());
    }

    private final class ThreadLocalCharsetEncoder
    extends ThreadLocal<CharsetEncoder> {
        private ThreadLocalCharsetEncoder() {
        }

        @Override
        protected CharsetEncoder initialValue() {
            return FsCharsetArchiveDriver.this.getCharset().newEncoder();
        }

        boolean canEncode(CharSequence cs) {
            return ((CharsetEncoder)this.get()).canEncode(cs);
        }
    }
}

