/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.sl;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.util.Maps;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FsDriverLocator
implements FsDriverProvider {
    public static final FsDriverLocator SINGLETON = new FsDriverLocator();

    private FsDriverLocator() {
    }

    @Override
    public Map<FsScheme, FsDriver> get() {
        return Boot.DRIVERS;
    }

    private static final class Boot {
        static final Map<FsScheme, FsDriver> DRIVERS;

        private Boot() {
        }

        static {
            FsScheme scheme;
            Logger logger = Logger.getLogger(FsDriverLocator.class.getName(), FsDriverLocator.class.getName());
            Iterator<FsDriverService> i = new ServiceLocator(FsDriverLocator.class.getClassLoader()).getServices(FsDriverService.class);
            TreeMap<FsScheme, FsDriver> sorted = new TreeMap<FsScheme, FsDriver>();
            if (!i.hasNext()) {
                logger.log(Level.WARNING, "null", FsDriverService.class);
            }
            while (i.hasNext()) {
                FsDriverService service = i.next();
                logger.log(Level.CONFIG, "located", service);
                for (Map.Entry<Object, Object> entry : service.get().entrySet()) {
                    FsDriver oldDriver;
                    scheme = (FsScheme)entry.getKey();
                    FsDriver newDriver = (FsDriver)entry.getValue();
                    if (null == scheme || null == newDriver || null == (oldDriver = sorted.put(scheme, newDriver)) || oldDriver.getPriority() <= newDriver.getPriority()) continue;
                    sorted.put(scheme, oldDriver);
                }
            }
            LinkedHashMap<FsScheme, FsDriver> fast = new LinkedHashMap<FsScheme, FsDriver>(Maps.initialCapacity(sorted.size()));
            for (Map.Entry<Object, Object> entry : sorted.entrySet()) {
                scheme = (FsScheme)entry.getKey();
                FsDriver driver = (FsDriver)entry.getValue();
                logger.log(Level.CONFIG, "mapping", new Object[]{scheme, driver});
                fast.put(scheme, driver);
            }
            DRIVERS = Collections.unmodifiableMap(fast);
        }
    }
}

