/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsScheme;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsSchemeTest {
    private static final Logger logger = Logger.getLogger(FsSchemeTest.class.getName());

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"foo"}, {"foo+bar"}, {"foo-bar"}, {"foo.bar"}, {"tar.bz2"}}) {
            FsScheme original = FsScheme.create((String)params[0]);
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINEST, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object clone = ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINEST, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsScheme.create(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsScheme(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String param : new String[]{"", "+", "-", "."}) {
            try {
                FsScheme.create((String)param);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsScheme(param);
                Assert.fail((String)param);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testEquality() {
        for (String[] params : new String[][]{{"foo"}, {"foo+bar"}, {"foo-bar"}, {"foo.bar"}, {"tar.bz2"}}) {
            FsScheme original = FsScheme.create((String)params[0]);
            FsScheme copy = FsScheme.create((String)params[0].toUpperCase(Locale.ENGLISH));
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            Assert.assertThat((Object)copy.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)params[0])));
            Assert.assertThat((Object)copy, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)copy.hashCode(), (Matcher)CoreMatchers.equalTo((Object)original.hashCode()));
            Assert.assertThat((Object)original.compareTo(copy), (Matcher)CoreMatchers.is((Object)0));
        }
    }
}

