/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.test.TestConfig;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.When;
import java.io.IOException;
import java.util.Random;
import org.junit.After;
import org.junit.Before;

public abstract class FsArchiveDriverTestBase<D extends FsArchiveDriver<?>> {
    private static final byte[] DATA = new byte[1024];
    private byte[] data;
    private volatile D driver;

    @Before
    @OverrideMustInvoke(value=When.FIRST)
    public void setUp() throws IOException {
        this.data = (byte[])DATA.clone();
        TestConfig config = TestConfig.push();
        config.setDataSize(this.data.length * 4 / 3);
        config.setIOPoolProvider(null);
    }

    @After
    @OverrideMustInvoke(value=When.LAST)
    public void tearDown() {
        TestConfig.pop();
    }

    protected final TestConfig getTestConfig() {
        return TestConfig.get();
    }

    protected final byte[] getData() {
        return this.data;
    }

    protected final int getDataLength() {
        return this.data.length;
    }

    protected final D getArchiveDriver() {
        D driver = this.driver;
        return null != driver ? driver : (this.driver = this.newArchiveDriver());
    }

    protected abstract D newArchiveDriver();

    static {
        new Random().nextBytes(DATA);
    }
}

