/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultModel;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriverTestBase;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.mock.MockController;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Throwables;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.junit.Assert;
import org.junit.Test;

public abstract class FsArchiveDriverTestSuite<E extends FsArchiveEntry, D extends FsArchiveDriver<E>>
extends FsArchiveDriverTestBase<D> {
    private static final Logger logger = Logger.getLogger(FsArchiveDriverTestSuite.class.getName());
    private static final FsEntryName name = FsEntryName.create((URI)URI.create("archive"));
    private static final FsModel model = FsArchiveDriverTestSuite.newArchiveModel();
    private FsController<?> parent;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        TestConfig config = this.getTestConfig();
        config.setDataSize(this.getMaxArchiveLength());
        config.setIOPoolProvider(null);
        this.parent = this.newController(model.getParent());
    }

    @Test
    public void testArchiveDriverMustBeFederated() {
        Assert.assertTrue((boolean)this.getArchiveDriver().isFederated());
    }

    @Test
    public void testIOPoolMustNotBeNull() {
        Assert.assertNotNull((Object)this.getArchiveDriver().getPool());
    }

    @Test
    public void testIOPoolShouldBeConstant() {
        IOPool p2;
        IOPool p1 = this.getArchiveDriver().getPool();
        if (p1 != (p2 = this.getArchiveDriver().getPool())) {
            logger.log(Level.WARNING, "{0} returns different I/O buffer pools upon multiple invocations of getPool()!", this.getArchiveDriver().getClass());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNewControllerMustNotTolerateNullModel() {
        this.getArchiveDriver().newController(null, this.parent);
    }

    @Test(expected=NullPointerException.class)
    public void testNewControllerMustNotTolerateNullParent() {
        this.getArchiveDriver().newController(model, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewControllerMustCheckParentMemberMatch1() {
        this.getArchiveDriver().newController(model.getParent(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewControllerMustCheckParentMemberMatch2() {
        this.getArchiveDriver().newController(model.getParent(), this.parent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewControllerMustCheckParentMemberMatch3() {
        this.getArchiveDriver().newController(model, (FsController)this.newController(model));
    }

    @Test
    public void testNewControllerMustNotReturnNull() {
        Assert.assertNotNull((Object)this.getArchiveDriver().newController(model, this.parent));
    }

    @Test
    public void testNewControllerMustMeetPostConditions() {
        FsController c = this.getArchiveDriver().newController(model, this.parent);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)model.getMountPoint(), (Object)c.getModel().getMountPoint());
        Assert.assertSame(this.parent, (Object)c.getParent());
    }

    @Test
    public void testGetInputSocketMustForwardTheCallToTheGivenController() {
        block2: {
            RuntimeException expected = new RuntimeException();
            this.trigger(MockController.class, expected);
            try {
                this.getArchiveInputSocket();
                Assert.fail();
            }
            catch (RuntimeException got) {
                if (Throwables.contains((Throwable)got, (Throwable)expected)) break block2;
                throw got;
            }
        }
    }

    @Test
    public void testGetOutputSocketMustForwardTheCallToTheGivenController() {
        block2: {
            RuntimeException expected = new RuntimeException();
            this.trigger(MockController.class, expected);
            try {
                this.getArchiveOutputSocket();
                Assert.fail();
            }
            catch (RuntimeException got) {
                if (Throwables.contains((Throwable)got, (Throwable)expected)) break block2;
                throw got;
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputShopMustNotTolerateNullModel() throws IOException {
        this.getArchiveDriver().newInputShop(null, this.getArchiveInputSocket());
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputShopMustNotTolerateNullInputSocket() throws IOException {
        this.getArchiveDriver().newInputShop(model, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputShopMustNotTolerateNullModel() throws IOException {
        this.getArchiveDriver().newOutputShop(null, this.getArchiveOutputSocket(), null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputShopMustNotTolerateNullInputSocket() throws IOException {
        this.getArchiveDriver().newOutputShop(model, null, null);
    }

    @Test
    public void testRoundTripPersistence() throws IOException {
        this.output();
        this.input();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output() throws IOException {
        OutputShop os = this.getArchiveDriver().newOutputShop(model, this.getArchiveOutputSocket(), null);
        try {
            Closeable[] streams = new Closeable[this.getNumEntries()];
            try {
                for (int i = 0; i < streams.length; ++i) {
                    streams[i] = this.output(os, i);
                }
            }
            finally {
                FsArchiveDriverTestSuite.close(streams);
            }
            this.check((EntryContainer<E>)os);
        }
        finally {
            IOException expected = new IOException();
            this.trigger(TestCloseable.class, expected);
            try {
                os.close();
            }
            catch (IOException got) {
                if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                    throw got;
                }
            }
            finally {
                this.clear(TestCloseable.class);
            }
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CreatesObligation
    private OutputStream output(OutputShop<E> shop, int i) throws IOException {
        String name = FsArchiveDriverTestSuite.name(i);
        E entry = this.newEntry(name);
        OutputSocket output = shop.getOutputSocket(entry);
        Assert.assertSame(entry, (Object)output.getLocalTarget());
        Assert.assertNull((Object)shop.getEntry(name));
        Assert.assertEquals((long)i, (long)shop.getSize());
        boolean failure = true;
        OutputStream out = output.newOutputStream();
        try {
            Assert.assertSame(entry, (Object)shop.getEntry(name));
            Assert.assertEquals((long)(i + 1), (long)shop.getSize());
            out.write(this.getData());
            failure = false;
        }
        finally {
            if (failure) {
                out.close();
            }
        }
        return out;
    }

    private OutputSocket<?> getArchiveOutputSocket() {
        return this.getArchiveDriver().getOutputSocket(this.parent, name, FsOutputOptions.NONE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void input() throws IOException {
        InputShop is = this.getArchiveDriver().newInputShop(model, this.getArchiveInputSocket());
        try {
            this.check((EntryContainer<E>)is);
            Closeable[] streams = new Closeable[this.getNumEntries()];
            try {
                for (int i = 0; i < streams.length; ++i) {
                    this.input(is, i).close();
                    streams[i] = this.input(is, i);
                }
            }
            finally {
                FsArchiveDriverTestSuite.close(streams);
            }
        }
        finally {
            IOException expected = new IOException();
            this.trigger(TestCloseable.class, expected);
            try {
                is.close();
            }
            catch (IOException got) {
                if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                    throw got;
                }
            }
            finally {
                this.clear(TestCloseable.class);
            }
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream input(InputShop<E> shop, int i) throws IOException {
        SeekableByteChannel channel;
        ReadOnlyFile rof;
        InputSocket input = shop.getInputSocket(FsArchiveDriverTestSuite.name(i));
        byte[] buf = new byte[this.getDataLength()];
        try {
            rof = input.newReadOnlyFile();
        }
        catch (UnsupportedOperationException ex) {
            rof = null;
            logger.log(Level.FINE, input.getClass() + " does not support newReadOnlyFile().", ex);
        }
        if (null != rof) {
            try {
                rof.readFully(buf);
                Assert.assertEquals((long)-1L, (long)rof.read());
            }
            finally {
                rof.close();
            }
            rof.close();
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), buf));
        }
        buf = new byte[this.getDataLength()];
        try {
            channel = input.newSeekableByteChannel();
        }
        catch (UnsupportedOperationException ex) {
            channel = null;
            logger.log(Level.FINE, input.getClass() + " does not support newSeekableByteChannel().", ex);
        }
        if (null != channel) {
            try {
                FsArchiveDriverTestSuite.readFully(channel, ByteBuffer.wrap(buf));
                Assert.assertEquals((long)-1L, (long)channel.read(ByteBuffer.wrap(buf)));
            }
            finally {
                channel.close();
            }
            channel.close();
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), buf));
        }
        buf = new byte[this.getDataLength()];
        boolean failure = true;
        DataInputStream in = new DataInputStream(input.newInputStream());
        try {
            in.readFully(buf);
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), buf));
            Assert.assertEquals((long)-1L, (long)in.read());
            failure = false;
        }
        finally {
            if (failure) {
                in.close();
            }
        }
        return in;
    }

    private InputSocket<?> getArchiveInputSocket() {
        return this.getArchiveDriver().getInputSocket(this.parent, name, FsInputOptions.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable[] resources) throws IOException {
        IOException failure = null;
        for (Closeable resource : resources) {
            if (null == resource) break;
            try {
                try {
                    resource.close();
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException ex) {
                failure = ex;
            }
        }
        if (null != failure) {
            throw failure;
        }
    }

    private <E extends FsArchiveEntry> void check(EntryContainer<E> container) {
        int numEntries = this.getNumEntries();
        Assert.assertEquals((long)numEntries, (long)container.getSize());
        Iterator it = container.iterator();
        for (int i = 0; i < numEntries; ++i) {
            FsArchiveEntry e = (FsArchiveEntry)it.next();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)FsArchiveDriverTestSuite.name(i), (Object)e.getName());
            Assert.assertSame((Object)Entry.Type.FILE, (Object)e.getType());
            Assert.assertEquals((long)this.getDataLength(), (long)e.getSize(Entry.Size.DATA));
            long storage = e.getSize(Entry.Size.STORAGE);
            Assert.assertTrue((-1L == storage || (long)this.getDataLength() <= storage ? 1 : 0) != 0);
            Assert.assertTrue((-1L != e.getTime(Entry.Access.WRITE) ? 1 : 0) != 0);
            try {
                it.remove();
                Assert.fail();
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
            Assert.assertSame((Object)e, (Object)container.getEntry(e.getName()));
        }
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            it.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)numEntries, (long)container.getSize());
    }

    private E newEntry(String name) throws CharConversionException {
        FsArchiveEntry e = this.getArchiveDriver().newEntry(name, Entry.Type.FILE, null);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)name, (Object)e.getName());
        Assert.assertSame((Object)Entry.Type.FILE, (Object)e.getType());
        Assert.assertTrue((-1L == e.getSize(Entry.Size.DATA) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getSize(Entry.Size.STORAGE) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.WRITE) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.READ) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.CREATE) ? 1 : 0) != 0);
        return (E)e;
    }

    private static String name(int i) {
        return Integer.toString(i);
    }

    private static void readFully(ReadableByteChannel rbc, ByteBuffer buf) throws IOException {
        int read;
        int len = buf.remaining();
        int total = 0;
        do {
            if (0 <= (read = rbc.read(buf))) continue;
            throw new EOFException();
        } while ((total += read) < len);
    }

    private MockController newController(FsModel model) {
        FsModel pm = model.getParent();
        MockController pc = null == pm ? null : this.newController(pm);
        return new TestController(model, pc);
    }

    private static FsModel newArchiveModel() {
        FsModel parent = FsArchiveDriverTestSuite.newNonArchiveModel();
        return new FsDefaultModel(FsMountPoint.create((URI)URI.create("scheme:" + parent.getMountPoint() + name + "!/")), parent);
    }

    private static FsModel newNonArchiveModel() {
        return new FsDefaultModel(FsMountPoint.create((URI)URI.create("file:/")), null);
    }

    private int getMaxArchiveLength() {
        return this.getNumEntries() * this.getDataLength() * 4 / 3;
    }

    private Throwable trigger(Class<?> from, Throwable toThrow) {
        return this.getThrowControl().trigger(from, toThrow);
    }

    private Throwable clear(Class<?> from) {
        return this.getThrowControl().clear(from);
    }

    private void checkAllExceptions(Object thiz) throws IOException {
        ThrowControl ctl = this.getThrowControl();
        ctl.check(thiz, IOException.class);
        ctl.check(thiz, RuntimeException.class);
        ctl.check(thiz, Error.class);
    }

    private ThrowControl getThrowControl() {
        return this.getTestConfig().getThrowControl();
    }

    private int getNumEntries() {
        return this.getTestConfig().getNumEntries();
    }

    private final class TestOutputStream
    extends DecoratingOutputStream
    implements TestCloseable {
        TestOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.delegate.close();
        }
    }

    private final class TestInputStream
    extends DecoratingInputStream
    implements TestCloseable {
        TestInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.delegate.close();
        }
    }

    private final class TestSeekableByteChannel
    extends DecoratingSeekableByteChannel
    implements TestCloseable {
        TestSeekableByteChannel(SeekableByteChannel channel) {
            super(channel);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.delegate.close();
        }
    }

    private final class TestReadOnlyFile
    extends DecoratingReadOnlyFile
    implements TestCloseable {
        TestReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.delegate.close();
        }
    }

    private static interface TestCloseable
    extends Closeable {
    }

    private final class TestController
    extends MockController {
        TestController(@CheckForNull FsModel model, FsController<?> parent) {
            super(model, parent, FsArchiveDriverTestSuite.this.getTestConfig());
        }

        @Override
        public InputSocket<?> getInputSocket(final FsEntryName name, final BitField<FsInputOption> options) {
            assert (null != name);
            assert (null != options);
            class Input
            extends DecoratingInputSocket<Entry> {
                Input() {
                    super(TestController.access$001(TestController.this, fsEntryName, bitField));
                }

                public ReadOnlyFile newReadOnlyFile() throws IOException {
                    return new TestReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
                }

                public SeekableByteChannel newSeekableByteChannel() throws IOException {
                    return new TestSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }

                public InputStream newInputStream() throws IOException {
                    return new TestInputStream(this.getBoundSocket().newInputStream());
                }
            }
            return new Input();
        }

        @Override
        public OutputSocket<?> getOutputSocket(final FsEntryName name, final BitField<FsOutputOption> options, final Entry template) {
            assert (null != name);
            assert (null != options);
            class Output
            extends DecoratingOutputSocket<Entry> {
                Output() {
                    super(TestController.access$101(TestController.this, fsEntryName, bitField, entry));
                }

                public SeekableByteChannel newSeekableByteChannel() throws IOException {
                    return new TestSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }

                public OutputStream newOutputStream() throws IOException {
                    return new TestOutputStream(this.getBoundSocket().newOutputStream());
                }
            }
            return new Output();
        }

        static /* synthetic */ InputSocket access$001(TestController x0, FsEntryName x1, BitField x2) {
            return super.getInputSocket(x1, (BitField<FsInputOption>)x2);
        }

        static /* synthetic */ OutputSocket access$101(TestController x0, FsEntryName x1, BitField x2, Entry x3) {
            return super.getOutputSocket(x1, (BitField<FsOutputOption>)x2, x3);
        }
    }
}

