/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.util.ExceptionBuilderTestSuite;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public abstract class SequentialIOExceptionBuilderTestSuite<X extends SequentialIOException>
extends ExceptionBuilderTestSuite<SequentialIOExceptionBuilder<IOException, X>, IOException, X> {
    protected SequentialIOExceptionBuilderTestSuite(Class<X> clazz) {
        super(clazz);
    }

    @Override
    protected final IOException newCause() {
        return new IOException("test");
    }

    @Test
    public void testIdentity() throws X {
        this.assertSequence(new Identity());
    }

    @Test
    public void testAppearance() throws X {
        this.assertSequence(new Appearance());
    }

    @Test
    public void testPriority() throws X {
        this.assertSequence(new Priority());
    }

    private void assertSequence(Mapper mapper) throws X {
        IOException warning = new IOException("warning");
        IOException failure = new IOException("failure");
        ((SequentialIOExceptionBuilder)this.builder).warn((Exception)warning);
        SequentialIOException ex1 = (SequentialIOException)((SequentialIOExceptionBuilder)this.builder).fail((Exception)failure);
        ((SequentialIOExceptionBuilder)this.builder).check();
        Assert.assertTrue((boolean)this.clazz.isInstance((Object)ex1));
        SequentialIOException ex2 = mapper.map(ex1);
        Assert.assertTrue((boolean)this.clazz.isInstance((Object)ex2));
        HashSet<IOException> causes = new HashSet<IOException>(Arrays.asList(warning, failure));
        Assert.assertTrue((boolean)causes.remove(ex2.getCause()));
        Assert.assertTrue((boolean)causes.remove(ex2.getPredecessor().getCause()));
        Assert.assertTrue((boolean)causes.isEmpty());
        Assert.assertNull((Object)ex2.getPredecessor().getPredecessor());
    }

    @Test
    public void testFailIdempotence() {
        SequentialIOException ex = (SequentialIOException)((SequentialIOExceptionBuilder)this.builder).fail((Exception)this.newCause());
        Assert.assertSame((Object)ex, (Object)((SequentialIOExceptionBuilder)this.builder).fail((Exception)ex));
    }

    @Test
    public void testWarnIdempotence() {
        ((SequentialIOExceptionBuilder)this.builder).warn((Exception)this.newCause());
        try {
            ((SequentialIOExceptionBuilder)this.builder).check();
            Assert.fail();
        }
        catch (SequentialIOException ex) {
            Assert.assertTrue((boolean)this.clazz.isInstance((Object)ex));
            ((SequentialIOExceptionBuilder)this.builder).warn((Exception)((Object)ex));
            try {
                ((SequentialIOExceptionBuilder)this.builder).check();
                Assert.fail();
            }
            catch (SequentialIOException ex2) {
                Assert.assertSame((Object)((Object)ex), (Object)((Object)ex2));
            }
        }
    }

    private final class Priority
    implements Mapper {
        private Priority() {
        }

        @Override
        public SequentialIOException map(SequentialIOException ex) {
            return ex.sortPriority();
        }
    }

    private final class Appearance
    implements Mapper {
        private Appearance() {
        }

        @Override
        public SequentialIOException map(SequentialIOException ex) {
            return ex.sortAppearance();
        }
    }

    private class Identity
    implements Mapper {
        private Identity() {
        }

        @Override
        public SequentialIOException map(SequentialIOException ex) {
            return ex;
        }
    }

    private static interface Mapper {
        public SequentialIOException map(SequentialIOException var1);
    }
}

