/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.SequentialIOException;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public final class SequentialIOExceptionTest {
    @Test
    public void testSorting() {
        SequentialIOException exc = null;
        int max = 9;
        Assert.assertEquals((long)0L, (long)0L);
        SequentialIOException[] appearance = new SequentialIOException[9];
        SequentialIOException[] priority = new SequentialIOException[9];
        for (int i = 0; i < 9; ++i) {
            File dummy = new File("" + (i + 1)).getAbsoluteFile();
            SequentialIOException sequentialIOException = exc = new TestException(dummy.getPath(), i % 3).initPredecessor(exc);
            priority[8 - i % 3 * 3 - i / 3] = sequentialIOException;
            appearance[8 - i] = sequentialIOException;
        }
        int maxIndex = exc.maxIndex;
        Assert.assertEquals((long)8L, (long)maxIndex);
        Check indexCheck = new Check(){

            @Override
            public boolean equals(SequentialIOException e1, SequentialIOException e2) {
                return e1 == e2;
            }
        };
        this.assertChain(indexCheck, appearance, exc);
        SequentialIOException appearanceExc = exc.sortAppearance();
        Assert.assertEquals((long)maxIndex, (long)appearanceExc.maxIndex);
        this.assertChain(indexCheck, appearance, appearanceExc);
        Check priorityCheck = new Check(){

            @Override
            public boolean equals(SequentialIOException e1, SequentialIOException e2) {
                return SequentialIOException.PRIORITY_COMP.compare(e1, e2) == 0;
            }
        };
        SequentialIOException priorityExc = exc.sortPriority();
        Assert.assertNotSame((Object)((Object)exc), (Object)((Object)priorityExc));
        Assert.assertEquals((long)maxIndex, (long)priorityExc.maxIndex);
        this.assertChain(priorityCheck, priority, priorityExc);
    }

    private void assertChain(Check c, SequentialIOException[] expected, SequentialIOException exc) {
        assert (c != null);
        for (int i = 0; i < expected.length; ++i) {
            SequentialIOException exp = expected[i];
            Assert.assertNotNull((Object)((Object)exp));
            Assert.assertNotNull((Object)((Object)exc));
            Assert.assertTrue((boolean)c.equals(exp, exc));
            exc = exc.getPredecessor();
        }
        Assert.assertNull((Object)((Object)exc));
    }

    @Test
    public void testInitPredecessor() {
        SequentialIOException exc1 = new SequentialIOException();
        SequentialIOException exc2 = new SequentialIOException();
        try {
            exc1.initPredecessor(exc1);
            Assert.fail((String)"A chainable exception can't be the predecessor of itself!");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            exc2.initPredecessor(exc1);
            Assert.fail((String)"A chainable exception's predecessor's predecessor must be initialized!");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        exc1.initPredecessor(null);
        exc1.initPredecessor(null);
        try {
            exc1.initPredecessor(exc2);
            Assert.fail((String)"Predecessor reinitialization not allowed!");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        exc2.initPredecessor(exc1);
        exc2.initPredecessor(exc1);
        try {
            exc2.initPredecessor(null);
            Assert.fail((String)"Predecessor reinitialization not allowed!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class TestException
    extends SequentialIOException {
        private static final long serialVersionUID = 4893204620357369739L;

        TestException(String message, int priority) {
            super(message, null, priority);
        }
    }

    private static interface Check {
        public boolean equals(SequentialIOException var1, SequentialIOException var2);
    }
}

