/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.IOException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.Icon;

public abstract class FsController<M extends FsModel> {
    public abstract M getModel();

    @Nullable
    public abstract FsController<?> getParent();

    @Deprecated
    @Nullable
    public abstract Icon getOpenIcon() throws IOException;

    @Deprecated
    @Nullable
    public abstract Icon getClosedIcon() throws IOException;

    public abstract boolean isReadOnly() throws IOException;

    @Nullable
    public abstract FsEntry getEntry(FsEntryName var1) throws IOException;

    public abstract boolean isReadable(FsEntryName var1) throws IOException;

    public abstract boolean isWritable(FsEntryName var1) throws IOException;

    public boolean isExecutable(FsEntryName name) throws IOException {
        return false;
    }

    public abstract void setReadOnly(FsEntryName var1) throws IOException;

    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        boolean ok = true;
        for (Map.Entry<Entry.Access, Long> time : times.entrySet()) {
            ok &= this.setTime(name, BitField.of((Enum)time.getKey()), time.getValue(), options);
        }
        return ok;
    }

    public abstract boolean setTime(FsEntryName var1, BitField<Entry.Access> var2, long var3, BitField<FsOutputOption> var5) throws IOException;

    public abstract InputSocket<?> getInputSocket(FsEntryName var1, BitField<FsInputOption> var2);

    public abstract OutputSocket<?> getOutputSocket(FsEntryName var1, BitField<FsOutputOption> var2, @CheckForNull Entry var3);

    public abstract void mknod(FsEntryName var1, Entry.Type var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4) throws IOException;

    public abstract void unlink(FsEntryName var1, BitField<FsOutputOption> var2) throws IOException;

    public final void sync(BitField<FsSyncOption> options) throws IOException {
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        this.sync(options, builder);
        builder.check();
    }

    public abstract <X extends IOException> void sync(BitField<FsSyncOption> var1, ExceptionHandler<? super FsSyncException, X> var2) throws IOException;

    public final boolean equals(@CheckForNull Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("%s[model=%s]", this.getClass().getName(), this.getModel());
    }
}

