/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultModel;
import de.schlichtherle.truezip.fs.FsFalsePositiveController;
import de.schlichtherle.truezip.fs.FsFinalizeController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncShutdownHook;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.Link;
import de.schlichtherle.truezip.util.Links;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FsDefaultManager
extends FsManager {
    @GuardedBy(value="this")
    private final Map<FsMountPoint, Link<FsFalsePositiveController>> schedulers = new WeakHashMap<FsMountPoint, Link<FsFalsePositiveController>>();
    private final Link.Type optionalScheduleType;

    public FsDefaultManager() {
        this(Link.Type.WEAK);
    }

    FsDefaultManager(Link.Type optionalScheduleType) {
        assert (null != optionalScheduleType);
        this.optionalScheduleType = optionalScheduleType;
    }

    @Override
    public synchronized FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver) {
        return this.getController(mountPoint, driver, null);
    }

    private FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver, @CheckForNull FsController<?> parent) {
        if (null == mountPoint.getParent()) {
            if (null != parent) {
                throw new IllegalArgumentException("Parent/member mismatch!");
            }
            FsDefaultModel model = new FsDefaultModel(mountPoint, null);
            return driver.newController(model, null);
        }
        FsFalsePositiveController controller = Links.getTarget(this.schedulers.get(mountPoint));
        if (null == controller) {
            if (null == parent) {
                parent = this.getController(mountPoint.getParent(), driver, null);
            }
            ScheduledModel model = new ScheduledModel(mountPoint, (FsModel)parent.getModel());
            controller = new FsFalsePositiveController(new FsFinalizeController(driver.newController(model, parent)));
            model.setController(controller);
        }
        return controller;
    }

    @Override
    public synchronized int getSize() {
        return this.schedulers.size();
    }

    @Override
    public Iterator<FsController<?>> iterator() {
        return this.getControllers().iterator();
    }

    private synchronized Set<FsController<?>> getControllers() {
        TreeSet snapshot = new TreeSet(ReverseControllerComparator.INSTANCE);
        for (Link<FsFalsePositiveController> link : this.schedulers.values()) {
            FsController controller = Links.getTarget(link);
            if (null == controller) continue;
            snapshot.add(controller);
        }
        return snapshot;
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super IOException, X> handler) throws X {
        FsSyncShutdownHook.SINGLETON.cancel();
        super.sync(options, handler);
    }

    private static final class ReverseControllerComparator
    implements Comparator<FsController<?>> {
        static final ReverseControllerComparator INSTANCE = new ReverseControllerComparator();

        private ReverseControllerComparator() {
        }

        @Override
        public int compare(FsController<?> o1, FsController<?> o2) {
            return ((FsModel)o2.getModel()).getMountPoint().toHierarchicalUri().compareTo(((FsModel)o1.getModel()).getMountPoint().toHierarchicalUri());
        }
    }

    private final class ScheduledModel
    extends FsDefaultModel {
        FsFalsePositiveController controller;
        boolean touched;

        ScheduledModel(FsMountPoint mountPoint, FsModel parent) {
            super(mountPoint, parent);
        }

        void setController(FsFalsePositiveController controller) {
            assert (null != controller);
            assert (!this.touched);
            this.controller = controller;
            this.schedule(false);
        }

        @Override
        public boolean isTouched() {
            return this.touched;
        }

        @Override
        public void setTouched(boolean touched) {
            if (this.touched != touched) {
                if (touched) {
                    FsSyncShutdownHook.SINGLETON.register(FsDefaultManager.this);
                }
                this.schedule(touched);
                this.touched = touched;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(boolean mandatory) {
            FsMountPoint mountPoint = this.getMountPoint();
            Link<FsFalsePositiveController> link = (mandatory ? Link.Type.STRONG : FsDefaultManager.this.optionalScheduleType).newLink(this.controller);
            FsDefaultManager fsDefaultManager = FsDefaultManager.this;
            synchronized (fsDefaultManager) {
                FsDefaultManager.this.schedulers.put(mountPoint, link);
            }
        }
    }
}

