/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsSyncShutdownHook
extends Thread {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    static final FsSyncShutdownHook SINGLETON = new FsSyncShutdownHook();
    @CheckForNull
    private volatile FsManager manager;

    private FsSyncShutdownHook() {
        this.setPriority(10);
    }

    @Override
    public void run() {
        FsManager manager = this.manager;
        if (manager != null) {
            try {
                manager.sync(FsSyncOptions.UMOUNT);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(FsManager manager) {
        if (this.manager != manager) {
            FsSyncShutdownHook fsSyncShutdownHook = this;
            synchronized (fsSyncShutdownHook) {
                if (this.manager != manager) {
                    RUNTIME.addShutdownHook(this);
                    this.manager = manager;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        if (this.manager != null) {
            FsSyncShutdownHook fsSyncShutdownHook = this;
            synchronized (fsSyncShutdownHook) {
                if (this.manager != null) {
                    RUNTIME.removeShutdownHook(this);
                    this.manager = null;
                }
            }
        }
    }
}

