/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.archive.FsArchiveDriverTestSuite;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.util.ConcurrencyUtils;
import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.annotation.CheckForNull;
import org.junit.Test;

public abstract class FsCharsetArchiveDriverTestSuite<E extends FsArchiveEntry, D extends FsCharsetArchiveDriver<E>>
extends FsArchiveDriverTestSuite<E, D> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String US_ASCII_CHARACTERS;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        assert (!UTF8.equals(((FsCharsetArchiveDriver)this.getArchiveDriver()).getCharset()) || null == this.getUnencodableName()) : "Bad test setup!";
    }

    @Test
    public void testCharsetMustNotBeNull() {
        assert (null != ((FsCharsetArchiveDriver)this.getArchiveDriver()).getCharset());
    }

    @Test(expected=CharConversionException.class)
    public void testUnencodableNameMustThrowCharConversionException() throws CharConversionException {
        String name = this.getUnencodableName();
        if (null == name) {
            throw new CharConversionException("Ignore me!");
        }
        ((FsCharsetArchiveDriver)this.getArchiveDriver()).assertEncodable(name);
    }

    @CheckForNull
    protected abstract String getUnencodableName();

    @Test
    public void testAllUsAsciiCharactersMustBeEncodable() throws CharConversionException {
        ((FsCharsetArchiveDriver)this.getArchiveDriver()).assertEncodable(US_ASCII_CHARACTERS);
    }

    @Test
    public void testAllUsAsciiCharactersMustBeEncodableWhenRunningMultithreaded() throws Throwable {
        final CountDownLatch start = new CountDownLatch(ConcurrencyUtils.NUM_IO_THREADS);
        class CheckFactory
        implements ConcurrencyUtils.TaskFactory {
            CheckFactory() {
            }

            @Override
            public Callable<?> newTask(int threadNum) {
                return new 1CheckFactory.Check();
            }

            class 1CheckFactory.Check
            implements Callable<Void> {
                1CheckFactory.Check() {
                }

                @Override
                public Void call() throws CharConversionException, InterruptedException {
                    start.countDown();
                    start.await();
                    for (int i = 0; i < 100000; ++i) {
                        ((FsCharsetArchiveDriver)FsCharsetArchiveDriverTestSuite.this.getArchiveDriver()).assertEncodable(US_ASCII_CHARACTERS);
                    }
                    return null;
                }
            }
        }
        ConcurrencyUtils.runConcurrent(ConcurrencyUtils.NUM_IO_THREADS, new CheckFactory()).join();
    }

    static {
        StringBuilder builder = new StringBuilder(128);
        for (char c = '\u0000'; c <= '\u007f'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        US_ASCII_CHARACTERS = builder.toString();
    }
}

