/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntries;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import java.util.EnumMap;
import javax.annotation.CheckForNull;

public final class MockArchiveDriverEntry
implements FsArchiveEntry {
    private final String name;
    private final Entry.Type type;
    private final EnumMap<Entry.Size, Long> sizes = new EnumMap(Entry.Size.class);
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    @CheckForNull
    private IOPool.Entry<?> buffer;

    public MockArchiveDriverEntry(String name, Entry.Type type, @CheckForNull Entry template) {
        assert (null != name);
        assert (null != type);
        this.name = name;
        this.type = type;
        if (null != template) {
            long value;
            for (Entry.Size size : ALL_SIZE_SET) {
                value = template.getSize(size);
                if (-1L == value) continue;
                this.sizes.put(size, value);
            }
            for (Entry.Access access : ALL_ACCESS_SET) {
                value = template.getTime(access);
                if (-1L == value) continue;
                this.times.put(access, value);
            }
        }
    }

    IOPool.Entry<?> getBuffer(IOPool<?> ioPool) throws IOException {
        IOPool.Entry buffer = this.buffer;
        return null != buffer ? buffer : (this.buffer = (IOPool.Entry)ioPool.allocate());
    }

    public String getName() {
        return this.name;
    }

    public Entry.Type getType() {
        return this.type;
    }

    public long getSize(Entry.Size type) {
        Long size = this.sizes.get(type);
        return null != size ? size : -1L;
    }

    public boolean setSize(Entry.Size type, long value) {
        this.sizes.put(type, value);
        return true;
    }

    public long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null != time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long value) {
        this.times.put(type, value);
        return true;
    }

    public String toString() {
        return FsArchiveEntries.toString((FsArchiveEntry)this);
    }
}

