/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ConcurrencyUtils {
    public static final int NUM_IO_THREADS = 10 * Runtime.getRuntime().availableProcessors();

    private ConcurrencyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskJoiner runConcurrent(int numThreads, TaskFactory factory) {
        ArrayList results = new ArrayList(numThreads);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            for (int threadNum = 0; threadNum < numThreads; ++threadNum) {
                results.add(executor.submit(factory.newTask(threadNum)));
            }
        }
        finally {
            executor.shutdown();
        }
        class TaskJoinerImpl
        implements TaskJoiner {
            final /* synthetic */ List val$results;

            TaskJoinerImpl(List list) {
                this.val$results = list;
            }

            @Override
            public void cancel() {
                for (Future result : this.val$results) {
                    result.cancel(true);
                }
            }

            @Override
            public void join() throws InterruptedException, ExecutionException {
                ExecutionException failure = null;
                for (Future result : this.val$results) {
                    try {
                        result.get();
                    }
                    catch (ExecutionException failed) {
                        failure = failed;
                    }
                    catch (CancellationException cancelled) {}
                }
                if (null != failure) {
                    throw failure;
                }
            }
        }
        return new TaskJoinerImpl(results);
    }

    public static interface TaskJoiner {
        public void cancel();

        public void join() throws InterruptedException, ExecutionException;
    }

    public static interface TaskFactory {
        public Callable<?> newTask(int var1);
    }
}

