/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.Icon;

@ThreadSafe
public final class FsSyncController<M extends FsModel>
extends FsDecoratingController<M, FsController<? extends M>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;

    public FsSyncController(FsController<? extends M> controller) {
        super(controller);
    }

    @Override
    @Deprecated
    public Icon getOpenIcon() throws IOException {
        while (true) {
            try {
                return this.delegate.getOpenIcon();
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    @Deprecated
    public Icon getClosedIcon() throws IOException {
        while (true) {
            try {
                return this.delegate.getClosedIcon();
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        while (true) {
            try {
                return this.delegate.isReadOnly();
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.getEntry(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isReadable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isWritable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isExecutable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isExecutable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        while (true) {
            try {
                this.delegate.setReadOnly(name);
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, times, options);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, types, value, options);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SOCKET_FACTORY.newInputSocket(this, name, options);
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return SOCKET_FACTORY.newOutputSocket(this, name, options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        while (true) {
            try {
                this.delegate.mknod(name, type, options, template);
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                this.delegate.unlink(name, options);
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    void close(Closeable closeable) throws IOException {
        while (true) {
            try {
                closeable.close();
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    private final class SyncOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsSyncController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            while (true) {
                try {
                    return new SyncOutputStream(this.getBoundSocket().newOutputStream());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(name, options, template);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsSyncController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            while (true) {
                try {
                    return new SyncReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            while (true) {
                try {
                    return new SyncInputStream(this.getBoundSocket().newInputStream());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName name, BitField<FsInputOption> options) {
            super(name, options);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsSyncController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Output(name, options, template);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsSyncController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsSyncController<?> fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Output(name, options, template);
            }
        };


        abstract InputSocket<?> newInputSocket(FsSyncController<?> var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsSyncController<?> var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

