/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FsMultiplexedOutputShop<E extends FsArchiveEntry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private final IOPool<?> pool;
    private final Map<String, BufferedEntryOutputStream> buffers = new LinkedHashMap<String, BufferedEntryOutputStream>();
    private boolean busy;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public FsMultiplexedOutputShop(@WillCloseWhenClosed OutputShop<E> output, IOPool<?> pool) {
        super(output);
        this.pool = pool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    @Override
    public int getSize() {
        return ((OutputShop)this.delegate).getSize() + this.buffers.size();
    }

    @Override
    public Iterator<E> iterator() {
        return new JointIterator(((OutputShop)this.delegate).iterator(), new BufferedEntriesIterator());
    }

    @Override
    @CheckForNull
    public E getEntry(String name) {
        FsArchiveEntry entry = (FsArchiveEntry)((OutputShop)this.delegate).getEntry(name);
        if (null != entry) {
            return (E)entry;
        }
        BufferedEntryOutputStream out = this.buffers.get(name);
        return null == out ? null : (E)out.getTarget();
    }

    @Override
    public OutputSocket<? extends E> getOutputSocket(E entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
                super(FsMultiplexedOutputShop.super.getOutputSocket(fsArchiveEntry));
            }

            @Override
            public E getLocalTarget() throws IOException {
                return this.val$entry;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                return FsMultiplexedOutputShop.this.isBusy() ? FsMultiplexedOutputShop.this.newBufferedEntryOutputStream(this.getBoundSocket()) : new EntryOutputStream(this.getBoundSocket());
            }
        }
        return new Output();
    }

    private BufferedEntryOutputStream newBufferedEntryOutputStream(OutputSocket<? extends E> output) throws IOException {
        IOPool.Entry buffer = (IOPool.Entry)this.pool.allocate();
        try {
            return new BufferedEntryOutputStream(buffer, output);
        }
        catch (IOException ex) {
            buffer.release();
            throw ex;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void close() throws IOException {
        if (this.isBusy()) {
            throw new IOException("Output shop is still busy!");
        }
        this.storeBuffers();
        assert (this.buffers.isEmpty());
        ((OutputShop)this.delegate).close();
    }

    private void storeBuffers() throws IOException {
        if (this.isBusy()) {
            return;
        }
        SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
        Iterator<BufferedEntryOutputStream> i = this.buffers.values().iterator();
        while (i.hasNext()) {
            BufferedEntryOutputStream out = i.next();
            boolean remove = true;
            try {
                remove = out.store(false);
            }
            catch (InputException ex) {
                builder.warn(ex);
            }
            catch (IOException ex) {
                throw (SequentialIOException)builder.fail(ex);
            }
            finally {
                if (!remove) continue;
                i.remove();
            }
        }
        builder.check();
    }

    private class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final InputSocket<Entry> input;
        final OutputSocket<? extends E> output;
        final IOPool.Entry<?> buffer;
        final E local;
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        BufferedEntryOutputStream(final IOPool.Entry<?> buffer, OutputSocket<? extends E> output) throws IOException {
            super(buffer.getOutputSocket().newOutputStream());
            this.output = output;
            this.local = (FsArchiveEntry)output.getLocalTarget();
            final Entry peer = output.getPeerTarget();
            this.buffer = buffer;
            class InputProxy
            extends DecoratingInputSocket<Entry> {
                InputProxy() {
                    super(entry.getInputSocket());
                }

                @Override
                public Entry getLocalTarget() {
                    return null != peer ? peer : buffer;
                }
            }
            this.input = new InputProxy();
            BufferedEntryOutputStream old = FsMultiplexedOutputShop.this.buffers.put(this.local.getName(), this);
            if (null != old) {
                old.store(true);
            }
        }

        E getTarget() {
            return this.local;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.delegate.close();
            this.closed = true;
            this.copyProperties();
            FsMultiplexedOutputShop.this.storeBuffers();
        }

        void copyProperties() throws IOException {
            Entry src = (Entry)this.input.getLocalTarget();
            Object dst = this.getTarget();
            if (-1L == dst.getSize(Entry.Size.DATA)) {
                dst.setSize(Entry.Size.DATA, src.getSize(Entry.Size.DATA));
            }
            for (Entry.Access type : Entry.ALL_ACCESS_SET) {
                if (-1L != dst.getTime(type)) continue;
                dst.setTime(type, src.getTime(type));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean store(boolean discard) throws IOException {
            if (discard) {
                assert (this.closed) : "broken archive controller!";
            } else if (!this.closed || FsMultiplexedOutputShop.this.isBusy()) {
                return false;
            }
            InputSocket<Entry> input = this.input;
            assert (null != input);
            OutputSocket output = this.output;
            assert (null != output);
            IOPool.Entry<?> buffer = this.buffer;
            assert (null != buffer);
            try {
                if (!discard) {
                    IOSocket.copy(input, output);
                }
            }
            finally {
                buffer.release();
            }
            return true;
        }
    }

    private class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(OutputSocket<? extends E> output) throws IOException {
            super(output.newOutputStream());
            FsMultiplexedOutputShop.this.busy = true;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.delegate.close();
            this.closed = true;
            FsMultiplexedOutputShop.this.busy = false;
            FsMultiplexedOutputShop.this.storeBuffers();
        }
    }

    private class BufferedEntriesIterator
    implements Iterator<E> {
        final Iterator<BufferedEntryOutputStream> i;

        private BufferedEntriesIterator() {
            this.i = FsMultiplexedOutputShop.this.buffers.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next().getTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

