/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;

@Immutable
final class FsResetController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    FsResetController(FsController<? extends FsLockModel> controller) {
        super(controller);
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        boolean checkRoot = true;
        try {
            this.delegate.unlink(name, options);
        }
        catch (FsFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            checkRoot = false;
            throw ex;
        }
        finally {
            if (checkRoot && name.isRoot()) {
                this.delegate.sync(FsSyncOptions.RESET);
            }
        }
    }
}

