/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.FsCovariantEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriver;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriverEntry;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriverEntryContainer;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.util.UriBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FsArchiveFileSystemTest {
    @Before
    public void setUp() {
        TestConfig.push();
    }

    @After
    public void tearDown() {
        TestConfig.pop();
    }

    @Test
    public void testPopulation() throws Exception {
        String[][] paramss = new String[][]{{".", ""}, {"\\t:st", null}, {"/test", null}, {"f:ck"}, {"t\u00e4scht"}, {"foo/", "foo"}, {"foo/bar", "foo", "foo/bar"}, {"foo//bar2", "foo", "foo/bar2"}, {"foo/./bar3", "foo", "foo/bar3"}, {"foo/../bar4", "bar4"}, {"foo\\..\\bar5", "bar5"}, {"./bar6", "bar6"}, {".\\bar7", "bar7"}, {"../bar8", null}, {"..\\bar9", null}};
        TestConfig config = TestConfig.get();
        config.setNumEntries(paramss.length);
        MockArchiveDriverEntryContainer container = MockArchiveDriverEntryContainer.create(config);
        MockArchiveDriver driver = new MockArchiveDriver(config);
        for (String[] params : paramss) {
            String aen = params[0];
            Entry.Type type = aen.endsWith("/") ? Entry.Type.DIRECTORY : Entry.Type.FILE;
            MockArchiveDriverEntry ae = (MockArchiveDriverEntry)driver.newEntry(aen, type, null);
            Assert.assertEquals((Object)aen, (Object)ae.getName());
            container.newOutputShop().getOutputSocket((Entry)ae).newOutputStream().close();
            Assert.assertSame((Object)ae, (Object)container.getEntry(aen));
        }
        Assert.assertEquals((long)paramss.length, (long)container.getSize());
        FsArchiveFileSystem fileSystem = FsArchiveFileSystem.newPopulatedFileSystem((FsArchiveDriver)driver, (EntryContainer)container, null, (boolean)false);
        assert (paramss.length <= fileSystem.getSize());
        Assert.assertNotNull((Object)fileSystem.getEntry(FsEntryName.ROOT));
        block1: for (String[] params : paramss) {
            String aen = params[0];
            if (1 == params.length) {
                params = new String[]{aen, aen};
            }
            for (int i = 1; i < params.length; ++i) {
                String cen = params[i];
                if (null == cen) continue;
                FsEntryName entryName = new FsEntryName(new UriBuilder().path(cen).getUri());
                Assert.assertEquals((Object)cen, (Object)entryName.getPath());
                Assert.assertEquals((Object)cen, (Object)fileSystem.getEntry(entryName).getName());
            }
            for (FsCovariantEntry ce : fileSystem) {
                for (MockArchiveDriverEntry ae : ce.getEntries()) {
                    if (!aen.equals(ae.getName())) continue;
                    continue block1;
                }
            }
            assert (false) : "No entry found with this name: " + aen;
        }
    }
}

