/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriverEntry;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriverEntryContainer;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MockArchiveDriver
extends FsCharsetArchiveDriver<MockArchiveDriverEntry> {
    private static final Charset charset = Charset.forName("UTF-8");
    private final TestConfig config;
    private final ConcurrentMap<FsMountPoint, MockArchiveDriverEntryContainer> containers;

    public MockArchiveDriver() {
        this(null);
    }

    public MockArchiveDriver(@CheckForNull TestConfig config) {
        super(charset);
        if (null == config) {
            config = TestConfig.get();
        }
        this.config = config;
        this.containers = new ConcurrentHashMap<FsMountPoint, MockArchiveDriverEntryContainer>(HashMaps.initialCapacity((int)config.getNumEntries()));
    }

    private IOPoolProvider getIOPoolProvider() {
        return this.config.getIOPoolProvider();
    }

    protected IOPool<?> getPool() {
        return this.getIOPoolProvider().get();
    }

    public InputShop<MockArchiveDriverEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        FsMountPoint mp = model.getMountPoint();
        input.getLocalTarget();
        MockArchiveDriverEntryContainer c = (MockArchiveDriverEntryContainer)this.containers.get(mp);
        if (null == c) {
            throw new FileNotFoundException(mp.toString());
        }
        return c.newInputShop();
    }

    public OutputShop<MockArchiveDriverEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<MockArchiveDriverEntry> source) throws IOException {
        FsMountPoint mp = model.getMountPoint();
        output.getLocalTarget();
        MockArchiveDriverEntryContainer n = MockArchiveDriverEntryContainer.create(this.config);
        MockArchiveDriverEntryContainer o = (MockArchiveDriverEntryContainer)this.containers.get(mp);
        if (null == o) {
            o = this.containers.putIfAbsent(mp, n);
        }
        return (null != o ? o : n).newOutputShop();
    }

    public MockArchiveDriverEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        return new MockArchiveDriverEntry(MockArchiveDriver.toZipOrTarEntryName((String)name, (Entry.Type)type), type, template);
    }
}

