/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.test;

import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.spi.ByteArrayIOPoolService;
import de.schlichtherle.truezip.test.ThrowControl;
import de.schlichtherle.truezip.util.InheritableThreadLocalStack;
import de.schlichtherle.truezip.util.Resource;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.Closeable;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@CleanupObligation
@ThreadSafe
public final class TestConfig
extends Resource<RuntimeException>
implements Closeable {
    public static final int DEFAULT_NUM_ENTRIES = 10;
    public static final int DEFAULT_DATA_LENGTH = 1024;
    private static final InheritableThreadLocalStack<TestConfig> configs = new InheritableThreadLocalStack();
    private static final TestConfig GLOBAL = new TestConfig();
    private final ThrowControl throwControl;
    private int numEmtries = 10;
    private int dataSize = 1024;
    private IOPoolProvider ioPoolProvider;

    public static TestConfig get() {
        return (TestConfig)configs.peekOrElse((Object)GLOBAL);
    }

    @CreatesObligation
    public static TestConfig push() {
        return (TestConfig)configs.push((Object)new TestConfig(TestConfig.get()));
    }

    public static void pop() {
        configs.popIf((Object)TestConfig.get());
    }

    private TestConfig() {
        this.throwControl = new ThrowControl();
    }

    private TestConfig(TestConfig template) {
        this.throwControl = new ThrowControl(template.getThrowControl());
        this.numEmtries = template.getNumEntries();
        this.dataSize = template.getDataSize();
        this.ioPoolProvider = template.getIOPoolProvider();
    }

    public ThrowControl getThrowControl() {
        return this.throwControl;
    }

    public int getNumEntries() {
        return this.numEmtries;
    }

    public void setNumEntries(int numEntries) {
        if (0 > numEntries) {
            throw new IllegalArgumentException();
        }
        this.numEmtries = numEntries;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataLength) {
        if (0 > dataLength) {
            throw new IllegalArgumentException();
        }
        this.dataSize = dataLength;
    }

    public IOPoolProvider getIOPoolProvider() {
        IOPoolProvider ioPoolProvider = this.ioPoolProvider;
        return null != ioPoolProvider ? ioPoolProvider : (this.ioPoolProvider = new ByteArrayIOPoolService(this.getDataSize()));
    }

    public void setIOPoolProvider(@CheckForNull IOPoolProvider ioPoolProvider) {
        this.ioPoolProvider = ioPoolProvider;
    }

    protected void onClose() {
        configs.popIf((Object)this);
    }
}

