/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSimpleCompositeDriver;
import de.schlichtherle.truezip.fs.mock.MockDriverService;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Link;
import java.net.URI;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FsManagerTestSuite {
    private final FsCompositeDriver driver = new FsSimpleCompositeDriver((FsDriverProvider)new MockDriverService("file|zip"));
    private FsManager manager;

    @Before
    public void setUp() {
        this.manager = this.newManager(Link.Type.WEAK);
    }

    protected abstract FsManager newManager(Link.Type var1);

    @Test
    public void testGetControllerWithNull() {
        for (Link.Type type : BitField.allOf(Link.Type.class)) {
            try {
                this.newManager(type).getController(null, null);
                Assert.fail();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test
    public void testForward() throws InterruptedException {
        for (String[] params : new String[][]{{"file:/", "zip:file:/\u00f6uter.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/"}, {"file:/", "zip:file:/f\u00f6o.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/"}}) {
            FsController parent = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.getController(mountPoint, this.driver);
                if (null != parent && null != parent.getParent()) {
                    Assert.assertThat((Object)controller.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
                }
                parent = controller;
            }
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)params.length));
            parent = null;
            this.waitAllManagers();
        }
    }

    @Test
    public void testBackward() throws InterruptedException {
        for (String[] params : new String[][]{{"zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:file:/\u00f6uter.zip!/", "file:/"}, {"zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:file:/f\u00f6o.zip!/", "file:/"}}) {
            FsController top = null;
            FsController member = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.getController(mountPoint, this.driver);
                if (null != member && null != controller.getParent()) {
                    Assert.assertThat((Object)controller, (Matcher)CoreMatchers.sameInstance((Object)member.getParent()));
                }
                member = controller;
                if (null != top) continue;
                top = controller;
            }
            Iterator i = this.manager.iterator();
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                Assert.assertThat((Object)((FsController)i.next()).getModel().getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            }
            Assert.assertThat((Object)i.hasNext(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)params.length));
            member = null;
            i = null;
            top = null;
            this.waitAllManagers();
        }
    }

    private void waitAllManagers() {
        do {
            System.gc();
        } while (0 < this.manager.getSize());
    }
}

