/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceAccountant;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FsResourceController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final FsResourceAccountant accountant = new FsResourceAccountant(this.writeLock());

    FsResourceController(FsController<? extends FsLockModel> controller) {
        super(controller);
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SOCKET_FACTORY.newInputSocket(this, name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return SOCKET_FACTORY.newOutputSocket(this, name, options, template);
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        this.waitIdle(options, builder);
        this.closeAll(builder);
        try {
            this.delegate.sync(options);
        }
        catch (FsSyncException ex) {
            builder.warn(ex);
        }
        builder.check();
    }

    private void waitIdle(BitField<FsSyncOption> options, FsSyncExceptionBuilder builder) throws FsSyncException {
        try {
            this.waitIdle(options);
        }
        catch (FsResourceOpenException ex) {
            if (!options.get(FsSyncOption.FORCE_CLOSE_INPUT) && !options.get(FsSyncOption.FORCE_CLOSE_OUTPUT)) {
                throw (FsSyncException)builder.fail(new FsSyncException((FsModel)this.getModel(), ex));
            }
            builder.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
        }
    }

    private void waitIdle(BitField<FsSyncOption> options) throws FsResourceOpenException {
        boolean force = options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
        FsResourceAccountant.Resources r = this.accountant.resources();
        if (0 != r.local && !force) {
            throw new FsResourceOpenException(r.total, r.local);
        }
        boolean wait = options.get(FsSyncOption.WAIT_CLOSE_INPUT) || options.get(FsSyncOption.WAIT_CLOSE_OUTPUT);
        this.accountant.waitOtherThreads(wait ? 0L : 100L);
        FsResourceAccountant.Resources r2 = this.accountant.resources();
        if (0 != r2.total) {
            throw new FsResourceOpenException(r2.total, r2.local);
        }
    }

    private void closeAll(final FsSyncExceptionBuilder builder) {
        final class IOExceptionHandler
        implements ExceptionHandler<IOException, RuntimeException> {
            IOExceptionHandler() {
            }

            @Override
            public RuntimeException fail(IOException ex) {
                throw new AssertionError((Object)ex);
            }

            @Override
            public void warn(IOException ex) {
                builder.warn(new FsSyncWarningException((FsModel)FsResourceController.this.getModel(), ex));
            }
        }
        this.accountant.closeAllResources(new IOExceptionHandler());
    }

    private void close(Closeable delegate, Closeable thiz) throws IOException {
        boolean cfe = false;
        try {
            delegate.close();
        }
        catch (ControlFlowException ex) {
            cfe = true;
            throw ex;
        }
        finally {
            if (!cfe) {
                this.accountant.stopAccountingFor(thiz);
            }
        }
    }

    private final class ResourceOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        ResourceOutputStream(OutputStream out) {
            super(out);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        ResourceInputStream(InputStream in) {
            super(in);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        ResourceSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        ResourceReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsResourceController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return new ResourceOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(name, options, template);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsResourceController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return new ResourceReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new ResourceInputStream(this.getBoundSocket().newInputStream());
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName name, BitField<FsInputOption> options) {
            super(name, options);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Output(name, options, template);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Output(name, options, template);
            }
        };


        abstract InputSocket<?> newInputSocket(FsResourceController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsResourceController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

