/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockController;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsSyncController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private static final BitField<FsSyncOption> NOT_WAIT_CLOSE_IO = BitField.of((Enum)FsSyncOption.WAIT_CLOSE_INPUT, (Enum[])new FsSyncOption[]{FsSyncOption.WAIT_CLOSE_OUTPUT}).not();

    FsSyncController(FsController<? extends FsLockModel> controller) {
        super(controller);
    }

    void sync(FsNeedsSyncException trigger) throws FsSyncException {
        this.checkWriteLockedByCurrentThread();
        try {
            this.sync(FsSyncOptions.SYNC);
        }
        catch (FsSyncException ex) {
            if (JSE7.AVAILABLE) {
                ex.addSuppressed(trigger);
            }
            throw ex;
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        while (true) {
            try {
                return this.delegate.isReadOnly();
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.getEntry(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isReadable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isWritable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isExecutable(FsEntryName name) throws IOException {
        while (true) {
            try {
                return this.delegate.isExecutable(name);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        while (true) {
            try {
                this.delegate.setReadOnly(name);
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, times, options);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                return this.delegate.setTime(name, types, value, options);
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SOCKET_FACTORY.newInputSocket(this, name, options);
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return SOCKET_FACTORY.newOutputSocket(this, name, options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        while (true) {
            try {
                this.delegate.mknod(name, type, options, template);
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        while (true) {
            try {
                this.delegate.unlink(name, options);
                if (name.isRoot()) {
                    this.delegate.sync(FsSyncOptions.RESET);
                }
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        BitField<FsSyncOption> modified = FsSyncController.modify(options);
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        while (true) {
            try {
                this.delegate.sync(modified);
            }
            catch (FsSyncWarningException ex) {
                if (ex.getCause() instanceof FsResourceOpenException && FsSyncController.forceCloseIo(modified)) {
                    builder.warn(ex);
                    continue;
                }
                throw (FsSyncException)builder.fail(ex);
            }
            catch (FsSyncException ex) {
                if (ex.getCause() instanceof FsResourceOpenException && modified != options) {
                    builder.check();
                    throw FsNeedsLockRetryException.get();
                }
                throw (FsSyncException)builder.fail(ex);
            }
            catch (FsNeedsSyncException yeahIKnow_IWasActuallyDoingThat) {
                continue;
            }
            break;
        }
        builder.check();
    }

    private static boolean forceCloseIo(BitField<FsSyncOption> options) {
        return options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
    }

    static BitField<FsSyncOption> modify(BitField<FsSyncOption> options) {
        BitField<FsSyncOption> result;
        boolean isRecursive = 1 < FsLockController.getLockCount();
        BitField<FsSyncOption> bitField = result = isRecursive ? options.and(NOT_WAIT_CLOSE_IO) : options;
        assert (result == options == result.equals(options)) : "Broken contract in BitField.and()!";
        assert (result == options || isRecursive);
        return result;
    }

    void close(Closeable closeable) throws IOException {
        while (true) {
            try {
                closeable.close();
                return;
            }
            catch (FsNeedsSyncException ex) {
                this.sync(ex);
                continue;
            }
            break;
        }
    }

    private final class SyncOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    private final class SyncReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        SyncReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public void close() throws IOException {
            FsSyncController.this.close(this.delegate);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsSyncController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            while (true) {
                try {
                    return new SyncOutputStream(this.getBoundSocket().newOutputStream());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(name, options, template);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsSyncController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            while (true) {
                try {
                    return (Entry)this.getBoundSocket().getLocalTarget();
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            while (true) {
                try {
                    return new SyncReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            while (true) {
                try {
                    return new SyncInputStream(this.getBoundSocket().newInputStream());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName name, BitField<FsInputOption> options) {
            super(name, options);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            while (true) {
                try {
                    return new SyncSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                }
                catch (FsNeedsSyncException ex) {
                    FsSyncController.this.sync(ex);
                    continue;
                }
                break;
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsSyncController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsSyncController fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsSyncController fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Nio2Output(name, options, template);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsSyncController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsSyncController fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsSyncController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsSyncController fsSyncController = controller;
                fsSyncController.getClass();
                return fsSyncController.new Output(name, options, template);
            }
        };


        abstract InputSocket<?> newInputSocket(FsSyncController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsSyncController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

