/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.SeekableByteBufferChannel;
import de.schlichtherle.truezip.rof.ByteArrayReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.EnumMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ByteArrayIOBuffer
implements IOEntry<ByteArrayIOBuffer> {
    private static final SocketFactory FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final String name;
    private int initialCapacity;
    @Nullable
    private byte[] data;
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    private int reads;
    private int writes;

    public ByteArrayIOBuffer(String name, int initialCapacity) {
        this(name, null, initialCapacity);
    }

    public ByteArrayIOBuffer(String name, byte[] data) {
        this(name, data, data.length);
    }

    private ByteArrayIOBuffer(String name, @CheckForNull byte[] data, int initialCapacity) {
        this.name = name;
        if (null == this.name) {
            throw new NullPointerException();
        }
        this.setData(data);
        this.setInitialCapacity(initialCapacity);
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final void setInitialCapacity(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @Nullable
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public final byte[] getData() {
        return this.data;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public final void setData(@CheckForNull byte[] data) {
        this.data = data;
    }

    public final String getName() {
        return this.name;
    }

    public final long getSize(Entry.Size type) {
        return null != this.data ? (long)this.data.length : -1L;
    }

    public final int getCount(Entry.Access type) {
        return type == Entry.Access.WRITE ? this.writes : this.reads;
    }

    public final long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null != time ? time : -1L;
    }

    public final InputSocket<ByteArrayIOBuffer> getInputSocket() {
        return FACTORY.newInputSocket(this);
    }

    public final OutputSocket<ByteArrayIOBuffer> getOutputSocket() {
        return FACTORY.newOutputSocket(this);
    }

    public String toString() {
        return String.format("%s[name=%s]", this.getClass().getName(), this.getName());
    }

    static /* synthetic */ byte[] access$502(ByteArrayIOBuffer x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class DataOutputStream
    extends ByteArrayOutputStream {
        boolean closed;

        DataOutputStream() {
            super(ByteArrayIOBuffer.this.initialCapacity);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            super.close();
            ByteArrayIOBuffer.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            ByteArrayIOBuffer.access$502(ByteArrayIOBuffer.this, this.toByteArray());
            this.closed = true;
        }
    }

    private class DataInputStream
    extends ByteArrayInputStream {
        boolean closed;

        DataInputStream() {
            super(ByteArrayIOBuffer.this.data);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            super.close();
            ByteArrayIOBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private class DataOutputChannel
    extends SeekableByteBufferChannel {
        boolean closed;

        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DataOutputChannel() {
            super((ByteBuffer)ByteBuffer.allocate(ByteArrayIOBuffer.this.initialCapacity).limit(0));
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            super.close();
            ByteArrayIOBuffer.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            ByteBuffer buffer = this.getByteBuffer();
            ByteArrayIOBuffer.access$502(ByteArrayIOBuffer.this, Arrays.copyOf(buffer.array(), buffer.limit()));
            this.closed = true;
        }
    }

    private class DataInputChannel
    extends SeekableByteBufferChannel {
        boolean closed;

        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DataInputChannel() {
            super(ByteBuffer.wrap(ByteArrayIOBuffer.this.data).asReadOnlyBuffer());
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            super.close();
            ByteArrayIOBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private class DataReadOnlyFile
    extends ByteArrayReadOnlyFile {
        boolean closed;

        DataReadOnlyFile() {
            super(ByteArrayIOBuffer.this.data);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            super.close();
            ByteArrayIOBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private class ByteArrayOutputSocket
    extends OutputSocket<ByteArrayIOBuffer> {
        private ByteArrayOutputSocket() {
        }

        public final ByteArrayIOBuffer getLocalTarget() throws IOException {
            return ByteArrayIOBuffer.this;
        }

        final void count() {
            ByteArrayIOBuffer.this.writes++;
        }

        public final OutputStream newOutputStream() throws IOException {
            this.count();
            return new DataOutputStream();
        }
    }

    private final class Nio2ByteArrayOutputSocket
    extends ByteArrayOutputSocket {
        private Nio2ByteArrayOutputSocket() {
        }

        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            this.count();
            return new DataOutputChannel();
        }
    }

    private class ByteArrayInputSocket
    extends InputSocket<ByteArrayIOBuffer> {
        private ByteArrayInputSocket() {
        }

        public final ByteArrayIOBuffer getLocalTarget() throws IOException {
            return ByteArrayIOBuffer.this;
        }

        final void count() throws FileNotFoundException {
            if (null == ByteArrayIOBuffer.this.data) {
                throw new FileNotFoundException();
            }
            ByteArrayIOBuffer.this.reads++;
        }

        public final ReadOnlyFile newReadOnlyFile() throws IOException {
            this.count();
            return new DataReadOnlyFile();
        }

        public final InputStream newInputStream() throws IOException {
            this.count();
            return new DataInputStream();
        }
    }

    private final class Nio2ByteArrayInputSocket
    extends ByteArrayInputSocket {
        private Nio2ByteArrayInputSocket() {
        }

        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            this.count();
            return new DataInputChannel();
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<ByteArrayIOBuffer> newInputSocket(ByteArrayIOBuffer entry) {
                ByteArrayIOBuffer byteArrayIOBuffer = entry;
                byteArrayIOBuffer.getClass();
                return byteArrayIOBuffer.new Nio2ByteArrayInputSocket();
            }

            @Override
            OutputSocket<ByteArrayIOBuffer> newOutputSocket(ByteArrayIOBuffer entry) {
                ByteArrayIOBuffer byteArrayIOBuffer = entry;
                byteArrayIOBuffer.getClass();
                return byteArrayIOBuffer.new Nio2ByteArrayOutputSocket();
            }
        }
        ,
        OIO{

            @Override
            InputSocket<ByteArrayIOBuffer> newInputSocket(ByteArrayIOBuffer entry) {
                ByteArrayIOBuffer byteArrayIOBuffer = entry;
                byteArrayIOBuffer.getClass();
                return byteArrayIOBuffer.new ByteArrayInputSocket();
            }

            @Override
            OutputSocket<ByteArrayIOBuffer> newOutputSocket(ByteArrayIOBuffer entry) {
                ByteArrayIOBuffer byteArrayIOBuffer = entry;
                byteArrayIOBuffer.getClass();
                return byteArrayIOBuffer.new ByteArrayOutputSocket();
            }
        };


        abstract InputSocket<ByteArrayIOBuffer> newInputSocket(ByteArrayIOBuffer var1);

        abstract OutputSocket<ByteArrayIOBuffer> newOutputSocket(ByteArrayIOBuffer var1);
    }
}

