/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsSyncShutdownHook {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Hook hook = new Hook();

    private FsSyncShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(FsManager manager) {
        Hook hook = FsSyncShutdownHook.hook;
        if (hook.manager != manager) {
            Hook hook2 = hook;
            synchronized (hook2) {
                if (hook.manager != manager) {
                    RUNTIME.addShutdownHook(hook);
                    hook.manager = manager;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancel() {
        Hook hook = FsSyncShutdownHook.hook;
        if (hook.manager != null) {
            Hook hook2 = hook;
            synchronized (hook2) {
                if (hook.manager != null) {
                    RUNTIME.removeShutdownHook(hook);
                    hook.manager = null;
                }
            }
        }
    }

    private static final class Hook
    extends Thread {
        @CheckForNull
        volatile FsManager manager;

        Hook() {
            this.setPriority(10);
        }

        @Override
        public void run() {
            FsManager manager = this.manager;
            if (manager != null) {
                this.manager = null;
                try {
                    manager.sync(FsSyncOptions.UMOUNT);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

