/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ThrowingInputStream
extends DecoratingInputStream {
    private final ThrowControl control;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingInputStream(@WillCloseWhenClosed InputStream in) {
        this(in, null);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingInputStream(@WillCloseWhenClosed InputStream in, @CheckForNull ThrowControl control) {
        super(in);
        if (null == in) {
            throw new NullPointerException();
        }
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public int read() throws IOException {
        this.checkAllExceptions();
        return this.delegate.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAllExceptions();
        return this.delegate.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.checkAllExceptions();
        return this.delegate.skip(n);
    }

    public int available() throws IOException {
        this.checkAllExceptions();
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.delegate.close();
    }

    public void mark(int readlimit) {
        this.checkUndeclaredExceptions();
        this.delegate.mark(readlimit);
    }

    public void reset() throws IOException {
        this.checkAllExceptions();
        this.delegate.reset();
    }

    public boolean markSupported() {
        this.checkUndeclaredExceptions();
        return this.delegate.markSupported();
    }
}

