/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThrowingInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    private final TestConfig config;
    @CheckForNull
    private volatile ThrowControl control;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingInputShop(@WillCloseWhenClosed InputShop<E> shop) {
        this(shop, null);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingInputShop(@WillCloseWhenClosed InputShop<E> shop, @CheckForNull TestConfig config) {
        super(shop);
        this.config = null != config ? config : TestConfig.get();
    }

    private ThrowControl getThrowControl() {
        ThrowControl control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkAllExceptions() throws IOException {
        this.getThrowControl().check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.getThrowControl().check((Object)this, RuntimeException.class);
        this.getThrowControl().check((Object)this, Error.class);
    }

    public int getSize() {
        this.checkUndeclaredExceptions();
        return ((InputShop)this.delegate).getSize();
    }

    public Iterator<E> iterator() {
        this.checkUndeclaredExceptions();
        return ((InputShop)this.delegate).iterator();
    }

    public E getEntry(String name) {
        this.checkUndeclaredExceptions();
        return (E)((InputShop)this.delegate).getEntry(name);
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        ((InputShop)this.delegate).close();
    }

    public InputSocket<? extends E> getInputSocket(String name) {
        this.checkUndeclaredExceptions();
        return ((InputShop)this.delegate).getInputSocket(name);
    }
}

