/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DisconnectingInputStream;
import de.schlichtherle.truezip.io.DisconnectingSeekableByteChannel;
import de.schlichtherle.truezip.io.InputClosedException;
import de.schlichtherle.truezip.rof.DisconnectingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DisconnectingInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private boolean closed;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public DisconnectingInputShop(@WillCloseWhenClosed InputShop<E> input) {
        super(input);
    }

    public boolean isClosed() {
        return this.closed;
    }

    final void assertOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException(new InputClosedException());
        }
    }

    final void checkOpen() throws IOException {
        if (this.isClosed()) {
            throw new InputClosedException();
        }
    }

    @Override
    public int getSize() {
        this.assertOpen();
        return ((InputShop)this.delegate).getSize();
    }

    @Override
    public Iterator<E> iterator() {
        this.assertOpen();
        return ((InputShop)this.delegate).iterator();
    }

    @Override
    public E getEntry(String name) {
        this.assertOpen();
        return ((InputShop)this.delegate).getEntry(name);
    }

    @Override
    public InputSocket<? extends E> getInputSocket(String name) {
        return SOCKET_FACTORY.newInputSocket(this, ((InputShop)this.delegate).getInputSocket(name));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ((InputShop)this.delegate).close();
    }

    private final class DisconnectingInputStreamImpl
    extends DisconnectingInputStream {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingInputStreamImpl(InputStream in) {
            super(in);
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingInputShop.this.isClosed();
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.isOpen()) {
                this.delegate.close();
            }
        }
    }

    private final class DisconnectingSeekableByteChannelImpl
    extends DisconnectingSeekableByteChannel {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingSeekableByteChannelImpl(SeekableByteChannel sbc) {
            super(sbc);
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingInputShop.this.isClosed();
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.isOpen()) {
                this.delegate.close();
            }
        }
    }

    private final class DisconnectingReadOnlyFileImpl
    extends DisconnectingReadOnlyFile {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingReadOnlyFileImpl(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingInputShop.this.isClosed();
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.isOpen()) {
                this.delegate.close();
            }
        }
    }

    private class Input
    extends DecoratingInputSocket<E> {
        Input(InputSocket<? extends E> input) {
            super(input);
        }

        @Override
        protected InputSocket<? extends E> getBoundSocket() throws IOException {
            DisconnectingInputShop.this.checkOpen();
            return this.getDelegate().bind(this);
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return new DisconnectingReadOnlyFileImpl(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new DisconnectingInputStreamImpl(this.getBoundSocket().newInputStream());
        }
    }

    private class Nio2Input
    extends Input {
        Nio2Input(InputSocket<? extends E> input) {
            super(input);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new DisconnectingSeekableByteChannelImpl(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            <E extends Entry> InputSocket<? extends E> newInputSocket(DisconnectingInputShop<E> shop, InputSocket<? extends E> input) {
                DisconnectingInputShop<E> disconnectingInputShop = shop;
                disconnectingInputShop.getClass();
                return disconnectingInputShop.new Nio2Input(input);
            }
        }
        ,
        OIO{

            @Override
            <E extends Entry> InputSocket<? extends E> newInputSocket(DisconnectingInputShop<E> shop, InputSocket<? extends E> input) {
                DisconnectingInputShop<E> disconnectingInputShop = shop;
                disconnectingInputShop.getClass();
                return disconnectingInputShop.new Input(input);
            }
        };


        abstract <E extends Entry> InputSocket<? extends E> newInputSocket(DisconnectingInputShop<E> var1, InputSocket<? extends E> var2);
    }
}

