/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ThrowingReadOnlyFile
extends DecoratingReadOnlyFile {
    private final ThrowControl control;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof) {
        this(rof, null);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull ThrowControl control) {
        super(rof);
        if (null == rof) {
            throw new NullPointerException();
        }
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public long length() throws IOException {
        this.checkAllExceptions();
        return this.delegate.length();
    }

    public long getFilePointer() throws IOException {
        this.checkAllExceptions();
        return this.delegate.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.checkAllExceptions();
        this.delegate.seek(pos);
    }

    public int read() throws IOException {
        this.checkAllExceptions();
        return this.delegate.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAllExceptions();
        return this.delegate.read(b, off, len);
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.delegate.close();
    }
}

