/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.JSE7;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ConcurrencyUtils {
    public static final int NUM_CPU_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int NUM_IO_THREADS = 10 * NUM_CPU_THREADS;

    private ConcurrencyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskJoiner runConcurrent(int numThreads, TaskFactory factory) {
        final CountDownLatch latch = new CountDownLatch(numThreads);
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(numThreads);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            for (int threadNum = 0; threadNum < numThreads; ++threadNum) {
                final Callable<?> task = factory.newTask(threadNum);
                final class Starter
                implements Callable<Void> {
                    Starter() {
                    }

                    @Override
                    public Void call() throws Exception {
                        latch.countDown();
                        task.call();
                        return null;
                    }
                }
                results.add(executor.submit(new Starter()));
            }
        }
        finally {
            executor.shutdown();
        }
        final class TaskJoinerImpl
        implements TaskJoiner {
            final /* synthetic */ List val$results;

            TaskJoinerImpl(List list) {
                this.val$results = list;
            }

            @Override
            public void cancel() {
                for (Future result : this.val$results) {
                    result.cancel(true);
                }
            }

            @Override
            public void join() throws InterruptedException, ExecutionException {
                ExecutionException failure = null;
                for (Future result : this.val$results) {
                    try {
                        result.get();
                    }
                    catch (ExecutionException failed) {
                        if (null != failure && JSE7.AVAILABLE) {
                            failure.addSuppressed(failed);
                        }
                        failure = failed;
                    }
                    catch (CancellationException cancellationException) {}
                }
                if (null != failure) {
                    throw failure;
                }
            }
        }
        return new TaskJoinerImpl(results);
    }

    public static interface TaskJoiner {
        public void cancel();

        public void join() throws InterruptedException, ExecutionException;
    }

    public static interface TaskFactory {
        public Callable<?> newTask(int var1);
    }
}

