/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.fsp;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.UriBuilder;
import java.net.URI;

final class Scanner {
    private final FsPath root;
    private final TArchiveDetector detector;
    private final Paths.Splitter splitter = new Paths.Splitter('/', false);
    private final UriBuilder uri = new UriBuilder();

    Scanner(FsMountPoint root, TArchiveDetector detector) {
        this(new FsPath(root, FsEntryName.ROOT), detector);
    }

    Scanner(FsPath parent, TArchiveDetector detector) {
        assert (null != parent);
        assert (null != detector);
        this.root = parent;
        this.detector = detector;
    }

    FsPath toPath(URI uri) {
        assert (!uri.isOpaque());
        uri = uri.normalize();
        String path = uri.getPath();
        this.uri.path(path).query(uri.getQuery());
        return this.scan(path);
    }

    private FsPath scan(String input) {
        this.splitter.split(input);
        String parent = this.splitter.getParentPath();
        FsEntryName member = FsEntryName.create((URI)this.uri.path(this.splitter.getMemberName()).toUri());
        FsPath path = (null != parent ? this.scan(parent) : this.root).resolve(member);
        FsScheme scheme = this.detector.getScheme(member.toString());
        if (null != scheme) {
            path = new FsPath(FsMountPoint.create((FsScheme)scheme, (FsPath)path), FsEntryName.ROOT);
        }
        return path;
    }
}

