/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.fsp;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.nio.fsp.TFileSystem;
import de.schlichtherle.truezip.nio.fsp.TFileSystemProvider;
import de.schlichtherle.truezip.nio.fsp.TPath;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TFileSystem
extends FileSystem {
    private static final FsManager manager = FsManagerLocator.SINGLETON.get();
    private static final Map<FsMountPoint, TFileSystem> fileSystems = new WeakHashMap<FsMountPoint, TFileSystem>();
    private final FsMountPoint mountPoint;
    private final TFileSystemProvider provider;
    private volatile FsController<?> controller;

    static synchronized TFileSystem get(TPath path) {
        FsMountPoint mp = path.getPath().getMountPoint();
        TFileSystem fs = fileSystems.get(mp);
        if (null != fs) {
            return fs;
        }
        fs = new TFileSystem(mp, TFileSystemProvider.get(path));
        fileSystems.put(mp, fs);
        return fs;
    }

    private TFileSystem(FsMountPoint mountPoint, TFileSystemProvider provider) {
        this.mountPoint = mountPoint;
        this.provider = provider;
    }

    public static boolean isLenient() {
        return TFile.isLenient();
    }

    public static void setLenient(boolean lenient) {
        TFile.setLenient((boolean)lenient);
    }

    public FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    @Override
    public TFileSystemProvider provider() {
        return this.provider;
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        new FsFilteringManager(manager, this.getMountPoint()).sync(options);
    }

    @Override
    public void close() throws FsSyncException {
        this.sync((BitField<FsSyncOption>)FsManager.UMOUNT);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TPath getPath(String first, String ... more) {
        return new TPath(new FsPath(this.getMountPoint(), FsEntryName.ROOT), null, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    FsEntry getEntry(TPath path) throws IOException {
        FsEntryName name = path.getPath().getEntryName();
        return this.getController((FsCompositeDriver)path.getArchiveDetector()).getEntry(name);
    }

    InputSocket<?> getInputSocket(TPath path, BitField<FsInputOption> options) {
        FsEntryName name = path.getPath().getEntryName();
        return this.getController((FsCompositeDriver)path.getArchiveDetector()).getInputSocket(name, options);
    }

    OutputSocket<?> getOutputSocket(TPath path, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        FsEntryName name = path.getPath().getEntryName();
        return this.getController((FsCompositeDriver)path.getArchiveDetector()).getOutputSocket(name, options, template);
    }

    DirectoryStream<Path> newDirectoryStream(final TPath path, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        Set set;
        FsEntryName name = path.getPath().getEntryName();
        FsEntry entry = this.getController((FsCompositeDriver)path.getArchiveDetector()).getEntry(name);
        if (null == entry || null == (set = entry.getMembers())) {
            throw new NotDirectoryException(path.toString());
        }
        class Stream
        implements DirectoryStream<Path> {
            Stream() {
            }

            @Override
            public Iterator<Path> iterator() {
                class Adapter
                implements Iterator<Path> {
                    final UriBuilder uri;
                    final Iterator<String> i;
                    Path next;
                    final /* synthetic */ Set val$set;
                    final /* synthetic */ TPath val$path;
                    final /* synthetic */ DirectoryStream.Filter val$filter;
                    final /* synthetic */ TFileSystem this$0;

                    Adapter() {
                        this.this$0 = tFileSystem;
                        this.val$set = set;
                        this.val$path = tPath;
                        this.val$filter = filter;
                        this.uri = new UriBuilder();
                        this.i = this.val$set.iterator();
                    }

                    public boolean hasNext() {
                        while (this.i.hasNext()) {
                            this.next = new TPath(this.val$path, this.i.next(), new String[0]);
                            try {
                                if (!this.val$filter.accept(this.next)) continue;
                                return true;
                            }
                            catch (IOException ex) {
                                Logger.getLogger(TFileSystem.class.getName()).log(Level.WARNING, ex.toString(), ex);
                            }
                        }
                        this.next = null;
                        return false;
                    }

                    public Path next() {
                        if (null == this.next) {
                            throw new NoSuchElementException();
                        }
                        return this.next;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Adapter(TFileSystem.this, set, path, filter);
            }

            @Override
            public void close() {
            }
        }
        return new Stream();
    }

    void createDirectory(TPath path, FileAttribute<?> ... attrs) throws IOException {
        if (0 < attrs.length) {
            throw new UnsupportedOperationException();
        }
        FsEntryName name = path.getPath().getEntryName();
        this.getController((FsCompositeDriver)path.getArchiveDetector()).mknod(name, Entry.Type.DIRECTORY, FsOutputOptions.NO_OUTPUT_OPTION.set((Enum)FsOutputOption.CREATE_PARENTS, TFileSystem.isLenient()), null);
    }

    void delete(TPath path) throws IOException {
        FsEntryName name = path.getPath().getEntryName();
        this.getController((FsCompositeDriver)path.getArchiveDetector()).unlink(name);
    }

    FsController<?> getController(FsCompositeDriver driver) {
        FsController controller = this.controller;
        return null != controller ? controller : (this.controller = manager.getController(this.getMountPoint(), driver));
    }
}

