/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.fsp;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.nio.fsp.TFileSystem;
import de.schlichtherle.truezip.nio.fsp.TPath;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@DefaultAnnotation(value={NonNull.class})
public class TFileSystemProvider
extends FileSystemProvider {
    private static volatile TFileSystemProvider DEFAULT = new TFileSystemProvider();
    private final String scheme;
    private final FsMountPoint root;

    public static TFileSystemProvider get(TPath path) {
        TFileSystemProvider provider = DEFAULT;
        return null != provider ? provider : new TFileSystemProvider();
    }

    @Deprecated
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public TFileSystemProvider() {
        this("truezip", FsMountPoint.create((URI)URI.create("file:/")));
        DEFAULT = this;
    }

    private TFileSystemProvider(String scheme, FsMountPoint root) {
        this.scheme = FsScheme.create((String)scheme).toString();
        if (null == root) {
            throw new NullPointerException();
        }
        this.root = root;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public FsMountPoint getRoot() {
        return this.root;
    }

    private static TArchiveDetector getArchiveDetector(@CheckForNull Map<String, ?> env) {
        if (null == env) {
            return TPath.getDefaultArchiveDetector();
        }
        TArchiveDetector detector = (TArchiveDetector)env.get("ARCHIVE_DETECTOR");
        return null != detector ? detector : TPath.getDefaultArchiveDetector();
    }

    @Override
    public TFileSystem newFileSystem(Path path, Map<String, ?> env) {
        TPath p = new TPath(TFileSystemProvider.getArchiveDetector(env), path);
        if (null == p.getPath().getMountPoint().getParent()) {
            throw new UnsupportedOperationException("no prospective archive file detected");
        }
        return p.getFileSystem();
    }

    @Override
    public TFileSystem newFileSystem(URI uri, @CheckForNull Map<String, ?> env) {
        return new TPath(TFileSystemProvider.getArchiveDetector(env), uri).getFileSystem();
    }

    @Override
    public TFileSystem getFileSystem(URI uri) {
        return this.newFileSystem(uri, (Map)null);
    }

    @Override
    public TPath getPath(URI uri) {
        return new TPath(uri);
    }

    private static BitField<FsInputOption> mapInput(OpenOption ... options) {
        HashSet set = new HashSet(options.length * 4 / 3 + 1);
        Collections.addAll(set, options);
        return TFileSystemProvider.mapInput(set);
    }

    private static BitField<FsInputOption> mapInput(Set<? extends OpenOption> options) {
        int s = options.size();
        if (0 == s || 1 == s && options.contains(StandardOpenOption.READ)) {
            return FsInputOptions.NO_INPUT_OPTION;
        }
        throw new IllegalArgumentException(options.toString());
    }

    private static BitField<FsOutputOption> mapOutput(OpenOption ... options) {
        HashSet set = new HashSet(options.length * 4 / 3 + 1);
        Collections.addAll(set, options);
        return TFileSystemProvider.mapOutput(set);
    }

    private static BitField<FsOutputOption> mapOutput(Set<? extends OpenOption> options) {
        if (options.isEmpty()) {
            return FsOutputOptions.NO_OUTPUT_OPTION;
        }
        EnumSet<FsOutputOption> set = EnumSet.noneOf(FsOutputOption.class);
        block6: for (OpenOption openOption : options) {
            if (!(openOption instanceof StandardOpenOption)) {
                throw new UnsupportedOperationException(openOption.toString());
            }
            switch ((StandardOpenOption)openOption) {
                case READ: {
                    throw new IllegalArgumentException(openOption.toString());
                }
                case WRITE: 
                case TRUNCATE_EXISTING: 
                case CREATE: {
                    continue block6;
                }
                case APPEND: {
                    set.add(FsOutputOption.APPEND);
                    continue block6;
                }
                case CREATE_NEW: {
                    set.add(FsOutputOption.EXCLUSIVE);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(openOption.toString());
        }
        return set.isEmpty() ? FsOutputOptions.NO_OUTPUT_OPTION : BitField.copyOf(set);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        TPath p = TPath.promote(path);
        if (options.isEmpty() || options.contains(StandardOpenOption.READ)) {
            return p.getInputSocket((BitField<FsInputOption>)TFileSystemProvider.mapInput(options).set((Enum)FsInputOption.CACHE)).newSeekableByteChannel();
        }
        return p.getOutputSocket((BitField<FsOutputOption>)TFileSystemProvider.mapOutput(options).set((Enum)FsOutputOption.CACHE).set((Enum)FsOutputOption.CREATE_PARENTS, TFileSystem.isLenient()), null).newSeekableByteChannel();
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return TPath.promote(path).getInputSocket(TFileSystemProvider.mapInput(options)).newInputStream();
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return TPath.promote(path).getOutputSocket((BitField<FsOutputOption>)TFileSystemProvider.mapOutput(options).set((Enum)FsOutputOption.CREATE_PARENTS, TFileSystem.isLenient()), null).newOutputStream();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return TPath.promote(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        TPath.promote(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.delete0(TPath.promote(path));
    }

    private void delete0(TPath path) throws IOException {
        TPath.promote(path).delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.copy0(TPath.promote(source), TPath.promote(target), options);
    }

    private void copy0(TPath source, TPath target, CopyOption ... options) throws IOException {
        TFileSystemProvider.checkContains(source, target);
        boolean preserve = false;
        BitField outputOptions = BitField.of((Enum)FsOutputOption.EXCLUSIVE).set((Enum)FsOutputOption.CREATE_PARENTS, TFileSystem.isLenient());
        if (0 < options.length) {
            block4: for (CopyOption option : options) {
                if (!(option instanceof StandardCopyOption)) {
                    throw new UnsupportedOperationException(option.toString());
                }
                switch ((StandardCopyOption)option) {
                    case REPLACE_EXISTING: {
                        outputOptions = outputOptions.clear((Enum)FsOutputOption.EXCLUSIVE);
                        continue block4;
                    }
                    case COPY_ATTRIBUTES: {
                        preserve = true;
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedOperationException(option.toString());
                    }
                }
            }
        }
        InputSocket<?> input = source.getInputSocket((BitField<FsInputOption>)FsInputOptions.NO_INPUT_OPTION);
        OutputSocket<?> output = target.getOutputSocket((BitField<FsOutputOption>)outputOptions, preserve ? (Entry)input.getLocalTarget() : null);
        IOSocket.copy(input, output);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        TPath s = TPath.promote(source);
        TPath t = TPath.promote(target);
        if (null != t.getEntry()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        this.copy0(s, t, StandardCopyOption.COPY_ATTRIBUTES);
        this.delete0(s);
    }

    private static void checkContains(TPath a, TPath b) throws IOException {
        URI ub;
        URI ua = a.toRealPath(new LinkOption[0]).getPath().toHierarchicalUri();
        if (ua.resolve(ub = b.toRealPath(new LinkOption[0]).getPath().toHierarchicalUri()) != ub) {
            throw new IOException(b + " (contained in " + a + ")");
        }
    }

    @Override
    public boolean isSameFile(Path a, Path b) throws IOException {
        URI ua = TPath.promote(a).toRealPath(new LinkOption[0]).getPath().toHierarchicalUri();
        URI ub = TPath.promote(b).toRealPath(new LinkOption[0]).getPath().toHierarchicalUri();
        return ua.equals(ub);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return TPath.promote(path).getFileName().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        TPath p = TPath.promote(path);
        FsEntryName n = p.getPath().getEntryName();
        FsController<?> c = p.getController();
        if (null == c.getEntry(n)) {
            throw new NoSuchFileException(path.toString());
        }
        block5: for (AccessMode m : modes) {
            switch (m) {
                case READ: {
                    if (c.isReadable(n)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case WRITE: {
                    if (c.isWritable(n)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case EXECUTE: {
                    if (c.isExecutable(n)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (!type.isAssignableFrom(BasicFileAttributeView.class)) {
            throw new UnsupportedOperationException();
        }
        return (V)new FsEntryAttributeView(TPath.promote(path));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (!type.isAssignableFrom(BasicFileAttributes.class)) {
            throw new UnsupportedOperationException();
        }
        return (A)new FsEntryAttributes(TPath.promote(path));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class FsEntryAttributes
    implements BasicFileAttributes {
        private final FsEntry e;

        FsEntryAttributes(TPath path) throws IOException {
            this.e = path.getEntry();
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.e == null ? null : FileTime.fromMillis(this.e.getTime(Entry.Access.WRITE));
        }

        @Override
        public FileTime lastAccessTime() {
            return this.e == null ? null : FileTime.fromMillis(this.e.getTime(Entry.Access.READ));
        }

        @Override
        public FileTime creationTime() {
            return this.e == null ? null : FileTime.fromMillis(this.e.getTime(Entry.Access.CREATE));
        }

        @Override
        public boolean isRegularFile() {
            return this.e == null ? false : this.e.isType(Entry.Type.FILE);
        }

        @Override
        public boolean isDirectory() {
            return this.e == null ? false : this.e.isType(Entry.Type.DIRECTORY);
        }

        @Override
        public boolean isSymbolicLink() {
            return this.e == null ? false : this.e.isType(Entry.Type.SYMLINK);
        }

        @Override
        public boolean isOther() {
            return this.e == null ? false : this.e.isType(Entry.Type.SPECIAL);
        }

        @Override
        public long size() {
            return this.e == null ? -1L : this.e.getSize(Entry.Size.DATA);
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class FsEntryAttributeView
    implements BasicFileAttributeView {
        private final TPath path;

        FsEntryAttributeView(TPath path) {
            this.path = path;
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return new FsEntryAttributes(this.path);
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FsController<?> c = this.path.getController();
            EnumMap<Entry.Access, Long> t = new EnumMap<Entry.Access, Long>(Entry.Access.class);
            t.put(Entry.Access.WRITE, FsEntryAttributeView.toMillis(lastModifiedTime));
            t.put(Entry.Access.READ, FsEntryAttributeView.toMillis(lastAccessTime));
            t.put(Entry.Access.CREATE, FsEntryAttributeView.toMillis(createTime));
            c.setTime(this.path.getPath().getEntryName(), t);
        }

        private static long toMillis(FileTime time) {
            return time == null ? null : Long.valueOf(time.toMillis());
        }
    }

    public static interface Parameter {
        public static final String ARCHIVE_DETECTOR = "ARCHIVE_DETECTOR";
    }
}

