/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.fsp;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.nio.fsp.Scanner;
import de.schlichtherle.truezip.nio.fsp.TFileSystem;
import de.schlichtherle.truezip.nio.fsp.TFileSystemProvider;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class TPath
implements Path {
    private static final FsMountPoint CURRENT_DIRECTORY = FsMountPoint.create((URI)Paths.get("", new String[0]).toUri());
    private final TArchiveDetector detector;
    private final URI uri;
    @CheckForNull
    private volatile FsPath path;
    @CheckForNull
    private volatile TFileSystem fileSystem;
    @CheckForNull
    private volatile Integer hashCode;

    public TPath(String first, String ... more) {
        this((TArchiveDetector)null, first, more);
    }

    public TPath(@CheckForNull TArchiveDetector detector, String first, String ... more) {
        this.detector = null != detector ? detector : TPath.getDefaultArchiveDetector();
        this.uri = TPath.uri(first, more);
        assert (this.invariants());
    }

    public TPath(TPath parent, String first, String ... more) {
        this(parent, (TArchiveDetector)null, first, more);
    }

    public TPath(TPath parent, @CheckForNull TArchiveDetector detector, String first, String ... more) {
        this(parent.getPath(), null != detector ? detector : parent.getArchiveDetector(), first, more);
    }

    TPath(FsPath parent, @CheckForNull TArchiveDetector detector, String first, String ... more) {
        this.detector = null != detector ? detector : TPath.getDefaultArchiveDetector();
        URI uri = TPath.uri(first, more);
        this.uri = parent.toUri().resolve(uri);
        this.path = new Scanner(parent, detector).toPath(uri);
        assert (this.invariants());
    }

    public TPath(URI uri) {
        this(null, uri);
    }

    public TPath(@CheckForNull TArchiveDetector detector, URI uri) {
        this.detector = null != detector ? detector : TPath.getDefaultArchiveDetector();
        String p = uri.getPath();
        while (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        URI uRI = this.uri = uri.getPath().equals(p) ? uri : new UriBuilder(uri).path(p).toUri();
        assert (this.invariants());
    }

    private TPath(TArchiveDetector detector, URI uri, @CheckForNull FsPath path) {
        this.detector = detector;
        this.uri = uri;
        this.path = path;
        assert (this.invariants());
    }

    TPath(Path path) {
        this(null, path);
    }

    TPath(@CheckForNull TArchiveDetector detector, Path path) {
        this.detector = null != detector ? detector : TPath.getDefaultArchiveDetector();
        this.uri = new UriBuilder().path(path.toString().replace(path.getFileSystem().getSeparator(), "/")).toUri();
    }

    private static URI uri(String first, String ... more) {
        StringBuilder pb = new StringBuilder(first);
        for (String m : more) {
            pb.append('/').append(m.replace(File.separatorChar, '/'));
        }
        return new UriBuilder().path(pb.toString()).toUri();
    }

    private boolean invariants() {
        assert (null != this.getArchiveDetector());
        assert (null != this.getUri());
        assert (null != this.getPath());
        assert (null != this.getFileSystem());
        return true;
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public boolean isArchive() {
        FsPath path = this.getPath();
        boolean root = path.getEntryName().isRoot();
        FsMountPoint parent = path.getMountPoint().getParent();
        return root && null != parent;
    }

    public boolean isEntry() {
        FsPath path = this.getPath();
        boolean root = path.getEntryName().isRoot();
        FsMountPoint parent = path.getMountPoint().getParent();
        return !root ? null != parent : null != parent && null != parent.getParent();
    }

    public static TArchiveDetector getDefaultArchiveDetector() {
        return TFile.getDefaultArchiveDetector();
    }

    public static void setDefaultArchiveDetector(TArchiveDetector detector) {
        TFile.setDefaultArchiveDetector((TArchiveDetector)detector);
    }

    URI getUri() {
        return this.uri;
    }

    FsPath getPath() {
        FsPath p = this.path;
        return null != p ? p : (this.path = this.toPath(this.uri));
    }

    private FsPath toPath(URI uri) {
        return new Scanner(uri.isAbsolute() ? TFileSystemProvider.get(this).getRoot() : CURRENT_DIRECTORY, this.detector).toPath(uri);
    }

    @Override
    public TFileSystem getFileSystem() {
        TFileSystem fs = this.fileSystem;
        return null != fs ? fs : (this.fileSystem = TFileSystem.get(this));
    }

    @Override
    public boolean isAbsolute() {
        URI u = this.getUri();
        return u.isAbsolute() || u.getSchemeSpecificPart().startsWith("/");
    }

    @Override
    @Nullable
    public TPath getRoot() {
        return new TPath(this.getArchiveDetector(), this.toUri().resolve("/"), null);
    }

    @Override
    public TPath getFileName() {
        URI uri = this.getUri();
        URI parent = uri.resolve(".");
        URI member = parent.relativize(uri);
        return new TPath(this.getArchiveDetector(), member, this.path);
    }

    @Override
    public TPath getParent() {
        return new TPath(this.getArchiveDetector(), this.getUri().resolve("."));
    }

    @Override
    public int getNameCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TPath getName(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TPath subpath(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static TPath promote(Path path) {
        return (TPath)path;
    }

    @Override
    public boolean startsWith(Path that) {
        if (this.getFileSystem() != that.getFileSystem()) {
            return false;
        }
        return this.startsWith(TPath.promote(that).getPath().getEntryName().toString());
    }

    @Override
    public boolean startsWith(String other) {
        String name = this.getPath().getEntryName().toString();
        int ol = other.length();
        return name.startsWith(other) && (name.length() == ol || '/' == name.charAt(ol));
    }

    @Override
    public boolean endsWith(Path that) {
        if (this.getFileSystem() != that.getFileSystem()) {
            return false;
        }
        return this.endsWith(TPath.promote(that).getPath().getEntryName().toString());
    }

    @Override
    public boolean endsWith(String other) {
        int tl;
        String name = this.getPath().getEntryName().toString();
        int ol = other.length();
        return name.endsWith(other) && ((tl = name.length()) == ol || '/' == name.charAt(tl - ol));
    }

    @Override
    public TPath normalize() {
        return new TPath(this.getArchiveDetector(), this.getUri().normalize(), this.path);
    }

    @Override
    public Path resolve(Path other) {
        return this.resolve(other.toString());
    }

    @Override
    public TPath resolve(String other) {
        return new TPath(this.getArchiveDetector(), this.getUri().resolve(other));
    }

    @Override
    public TPath resolveSibling(Path other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TPath resolveSibling(String other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TPath relativize(Path other) {
        return new TPath(this.getArchiveDetector(), this.toUri().relativize(other.toUri()));
    }

    public TFile toFile() {
        URI uri = this.getUri();
        return uri.isAbsolute() ? new TFile(this.getPath()) : new TFile(uri.getSchemeSpecificPart(), this.getArchiveDetector());
    }

    @Override
    public URI toUri() {
        return this.getPath().toHierarchicalUri();
    }

    @Override
    public TPath toAbsolutePath() {
        return new TPath(this.getArchiveDetector(), this.toUri(), this.getPath());
    }

    @Override
    public TPath toRealPath(LinkOption ... options) throws IOException {
        return new TPath(this.getArchiveDetector(), this.toUri(), this.getPath());
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<Path> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Path)) {
            return false;
        }
        Path that = (Path)other;
        return this.toUri().equals(that.toUri());
    }

    @Override
    public int compareTo(Path that) {
        return this.toUri().compareTo(that.toUri());
    }

    @Override
    public int hashCode() {
        Integer hashCode = this.hashCode;
        return null != hashCode ? hashCode : (this.hashCode = Integer.valueOf(this.toUri().hashCode()));
    }

    @Override
    public String toString() {
        return this.getUri().toString();
    }

    FsController<?> getController() throws IOException {
        return this.getFileSystem().getController((FsCompositeDriver)this.getArchiveDetector());
    }

    FsEntry getEntry() throws IOException {
        return this.getFileSystem().getEntry(this);
    }

    public InputSocket<?> getInputSocket(BitField<FsInputOption> options) {
        return this.getFileSystem().getInputSocket(this, options);
    }

    public OutputSocket<?> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return this.getFileSystem().getOutputSocket(this, options, template);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.getFileSystem().newDirectoryStream(this, filter);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.getFileSystem().createDirectory(this, attrs);
    }

    void delete() throws IOException {
        this.getFileSystem().delete(this);
    }
}

