/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.nio.file.TFileSystem;
import de.schlichtherle.truezip.nio.file.TFileSystemProvider;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class TFileSystem
extends FileSystem {
    private static final FsManager manager = FsManagerLocator.SINGLETON.get();
    private final FsController<?> controller;
    private final TFileSystemProvider provider;

    TFileSystem(TPath path) {
        assert (null != path);
        this.controller = manager.getController(path.getAddress().getMountPoint(), (FsCompositeDriver)path.getArchiveDetector());
        this.provider = TFileSystemProvider.get(path.getName());
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getController());
        assert (null != this.provider());
        return true;
    }

    public static boolean isLenient() {
        return TConfig.get().isLenient();
    }

    public static void setLenient(boolean lenient) {
        TConfig.get().setLenient(lenient);
    }

    private FsController<?> getController() {
        return this.controller;
    }

    FsMountPoint getMountPoint() {
        return this.getController().getModel().getMountPoint();
    }

    @Override
    public TFileSystemProvider provider() {
        return this.provider;
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        new FsFilteringManager(manager, this.getMountPoint()).sync(options);
    }

    @Override
    public void close() throws FsSyncException {
        this.sync((BitField<FsSyncOption>)FsManager.UMOUNT);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(new TPath(this.getMountPoint().toHierarchicalUri().resolve("/")));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.singleton("basic");
    }

    @Override
    public TPath getPath(String first, String ... more) {
        return new TPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static BitField<FsInputOption> mapInput(OpenOption ... options) {
        HashSet set = new HashSet(options.length * 4 / 3 + 1);
        Collections.addAll(set, options);
        return TFileSystem.mapInput(set);
    }

    private static BitField<FsInputOption> mapInput(Set<? extends OpenOption> options) {
        int s = options.size();
        if (0 == s || 1 == s && options.contains(StandardOpenOption.READ)) {
            return FsInputOptions.NO_INPUT_OPTION;
        }
        throw new IllegalArgumentException(options.toString());
    }

    private static BitField<FsOutputOption> mapOutput(OpenOption ... options) {
        HashSet set = new HashSet(options.length * 4 / 3 + 1);
        Collections.addAll(set, options);
        return TFileSystem.mapOutput(set);
    }

    private static BitField<FsOutputOption> mapOutput(Set<? extends OpenOption> options) {
        EnumSet<FsOutputOption> set = EnumSet.noneOf(FsOutputOption.class);
        if (TConfig.get().isLenient()) {
            set.add(FsOutputOption.CREATE_PARENTS);
        }
        block6: for (OpenOption openOption : options) {
            if (!(openOption instanceof StandardOpenOption)) {
                throw new UnsupportedOperationException(openOption.toString());
            }
            switch ((StandardOpenOption)openOption) {
                case READ: {
                    throw new IllegalArgumentException(openOption.toString());
                }
                case WRITE: 
                case TRUNCATE_EXISTING: 
                case CREATE: {
                    continue block6;
                }
                case APPEND: {
                    set.add(FsOutputOption.APPEND);
                    continue block6;
                }
                case CREATE_NEW: {
                    set.add(FsOutputOption.EXCLUSIVE);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(openOption.toString());
        }
        return set.isEmpty() ? FsOutputOptions.NO_OUTPUT_OPTION : BitField.copyOf(set);
    }

    SeekableByteChannel newByteChannel(TPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FsEntryName name = path.getAddress().getEntryName();
        FsController<?> controller = this.getController();
        if (options.isEmpty() || options.contains(StandardOpenOption.READ)) {
            BitField o = TFileSystem.mapInput(options).set((Enum)FsInputOption.CACHE);
            return controller.getInputSocket(name, o).newSeekableByteChannel();
        }
        BitField o = TFileSystem.mapOutput(options).set((Enum)FsOutputOption.CACHE);
        try {
            return controller.getOutputSocket(name, o, null).newSeekableByteChannel();
        }
        catch (IOException ex) {
            if (o.get((Enum)FsOutputOption.EXCLUSIVE) && null != controller.getEntry(name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    InputStream newInputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().getInputSocket(path.getAddress().getEntryName(), TFileSystem.mapInput(options)).newInputStream();
    }

    OutputStream newOutputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().getOutputSocket(path.getAddress().getEntryName(), TFileSystem.mapOutput(options), null).newOutputStream();
    }

    DirectoryStream<Path> newDirectoryStream(final TPath path, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        Set set;
        FsEntryName name = path.getAddress().getEntryName();
        FsEntry entry = this.getController().getEntry(name);
        if (null == entry || null == (set = entry.getMembers())) {
            throw new NotDirectoryException(path.toString());
        }
        class Stream
        implements DirectoryStream<Path> {
            Stream() {
            }

            @Override
            public Iterator<Path> iterator() {
                class Adapter
                implements Iterator<Path> {
                    final Iterator<String> i;
                    Path next;
                    final /* synthetic */ Set val$set;
                    final /* synthetic */ TPath val$path;
                    final /* synthetic */ DirectoryStream.Filter val$filter;
                    final /* synthetic */ TFileSystem this$0;

                    Adapter() {
                        this.this$0 = tFileSystem;
                        this.val$set = set;
                        this.val$path = tPath;
                        this.val$filter = filter;
                        this.i = this.val$set.iterator();
                    }

                    public boolean hasNext() {
                        while (this.i.hasNext()) {
                            this.next = this.val$path.resolve(this.i.next());
                            try {
                                if (!this.val$filter.accept(this.next)) continue;
                                return true;
                            }
                            catch (IOException ex) {
                                throw new DirectoryIteratorException(ex);
                            }
                        }
                        this.next = null;
                        return false;
                    }

                    public Path next() {
                        if (null == this.next) {
                            throw new NoSuchElementException();
                        }
                        return this.next;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Adapter(TFileSystem.this, set, path, filter);
            }

            @Override
            public void close() {
            }
        }
        return new Stream();
    }

    void createDirectory(TPath path, FileAttribute<?> ... attrs) throws IOException {
        if (0 < attrs.length) {
            throw new UnsupportedOperationException();
        }
        FsController<?> controller = this.getController();
        FsEntryName name = path.getAddress().getEntryName();
        try {
            controller.mknod(name, Entry.Type.DIRECTORY, FsOutputOptions.NO_OUTPUT_OPTION.set((Enum)FsOutputOption.CREATE_PARENTS, TConfig.get().isLenient()), null);
        }
        catch (IOException ex) {
            if (null != controller.getEntry(name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    void delete(TPath path) throws IOException {
        this.getController().unlink(path.getAddress().getEntryName());
    }

    FsEntry getEntry(TPath path) throws IOException {
        return this.getController().getEntry(path.getAddress().getEntryName());
    }

    InputSocket<?> getInputSocket(TPath path, BitField<FsInputOption> options) {
        return this.getController().getInputSocket(path.getAddress().getEntryName(), options);
    }

    OutputSocket<?> getOutputSocket(TPath path, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return this.getController().getOutputSocket(path.getAddress().getEntryName(), options, template);
    }

    void checkAccess(TPath path, AccessMode ... modes) throws IOException {
        FsEntryName name = path.getAddress().getEntryName();
        FsController<?> controller = this.getController();
        if (null == controller.getEntry(name)) {
            throw new NoSuchFileException(path.toString());
        }
        block5: for (AccessMode m : modes) {
            switch (m) {
                case READ: {
                    if (controller.isReadable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case WRITE: {
                    if (controller.isWritable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case EXECUTE: {
                    if (controller.isExecutable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Nullable
    <V extends FileAttributeView> V getFileAttributeView(TPath path, Class<V> type, LinkOption ... options) {
        if (!type.isAssignableFrom(BasicFileAttributeView.class)) {
            return null;
        }
        return (V)new FsEntryAttributeView(path);
    }

    <A extends BasicFileAttributes> A readAttributes(TPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (!type.isAssignableFrom(BasicFileAttributes.class)) {
            throw new UnsupportedOperationException();
        }
        return (A)new FsEntryAttributes(path);
    }

    private final class FsEntryAttributes
    implements BasicFileAttributes {
        private final FsEntry entry;

        FsEntryAttributes(TPath path) throws IOException {
            this.entry = TFileSystem.this.getController().getEntry(path.getAddress().getEntryName());
            if (null == this.entry) {
                throw new NoSuchFileException(path.toString());
            }
        }

        @Override
        public FileTime lastModifiedTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.WRITE));
        }

        @Override
        public FileTime lastAccessTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.READ));
        }

        @Override
        public FileTime creationTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.CREATE));
        }

        @Override
        public boolean isRegularFile() {
            return this.entry.isType(Entry.Type.FILE);
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isType(Entry.Type.DIRECTORY);
        }

        @Override
        public boolean isSymbolicLink() {
            return this.entry.isType(Entry.Type.SYMLINK);
        }

        @Override
        public boolean isOther() {
            return this.entry.isType(Entry.Type.SPECIAL);
        }

        @Override
        public long size() {
            long size = this.entry.getSize(Entry.Size.DATA);
            return -1L == size ? 0L : size;
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class FsEntryAttributeView
    implements BasicFileAttributeView {
        private final TPath path;

        FsEntryAttributeView(TPath path) {
            this.path = path;
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return new FsEntryAttributes(this.path);
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FsController controller = TFileSystem.this.getController();
            EnumMap<Entry.Access, Long> times = new EnumMap<Entry.Access, Long>(Entry.Access.class);
            if (null != lastModifiedTime) {
                times.put(Entry.Access.WRITE, lastModifiedTime.toMillis());
            }
            if (null != lastAccessTime) {
                times.put(Entry.Access.READ, lastAccessTime.toMillis());
            }
            if (null != createTime) {
                times.put(Entry.Access.CREATE, createTime.toMillis());
            }
            controller.setTime(this.path.getAddress().getEntryName(), times);
        }
    }
}

