/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.nio.file.TestBase;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public class TPathTest
extends TestBase {
    @Test
    public void testIllegalConstructorParameters() {
        if ('\\' == File.separatorChar) {
            for (Object[] params : new Object[][]{{"c:", NO_MORE}, {"c:foo", NO_MORE}}) {
                try {
                    new TPath(params[0].toString(), (String[])params[1]);
                    Assert.fail();
                }
                catch (IllegalArgumentException expected) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testStringConstructor() {
        if ('\\' == File.separatorChar) {
            for (Object[] params : new Object[][]{{"c:/foo", NO_MORE, "c:/foo", "file:/c:/foo"}, {"//foo", new String[]{"bar", "baz"}, "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"///foo//", new String[]{"//bar//", "//", "//baz//"}, "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
                TPathTest.assertConstructorWithStrings(params);
            }
        }
        for (Object[] params : new Object[][]{{"/", NO_MORE, "/", ROOT_DIRECTORY}, {"/foo", NO_MORE, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{""}, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{"bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo", new String[]{"/bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo//", new String[]{"//", "//bar//", ""}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo", new String[]{""}, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{".."}, "/foo/..", ROOT_DIRECTORY}, {"/foo", new String[]{"/bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo.mok", new String[]{"/bar"}, "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"/foo", new String[]{"/bar.mok"}, "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"/foo.mok", new String[]{"/bar.mok"}, "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"", new String[]{"/foo"}, "foo", CURRENT_DIRECTORY + "foo"}, {"", new String[]{"foo"}, "foo", CURRENT_DIRECTORY + "foo"}, {"", NO_MORE, "", CURRENT_DIRECTORY}, {".", NO_MORE, ".", CURRENT_DIRECTORY}, {"foo", NO_MORE, "foo", CURRENT_DIRECTORY + "foo"}, {"foo", new String[]{""}, "foo", CURRENT_DIRECTORY + "foo"}, {"foo", new String[]{".."}, "foo/..", CURRENT_DIRECTORY}, {"foo", new String[]{"bar"}, "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"foo.mok", new String[]{"bar"}, "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo", new String[]{"bar.mok"}, "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo.mok", new String[]{"bar.mok"}, "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}}) {
            TPathTest.assertConstructorWithStrings(params);
        }
    }

    private static void assertConstructorWithStrings(Object ... params) {
        String first = params[0].toString();
        String[] more = (String[])params[1];
        String name = params[2].toString();
        FsPath address = FsPath.create((URI)URI.create(params[3].toString()));
        TPath path = new TPath(first, more);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)address.getMountPoint()));
        Assert.assertThat((Object)path.getEntryName(), (Matcher)CoreMatchers.equalTo((Object)address.getEntryName()));
    }

    @Test
    public void testUriConstructor() {
        for (Object[] params : new Object[][]{{"", "file", true}, {"/", "file", true}, {"file:/", "file", true}, {"foo:/", "foo", false}}) {
            URI uri = URI.create(params[0].toString());
            String scheme = params[1].toString();
            boolean succeeds = (Boolean)params[2];
            TPath path = new TPath(uri);
            URI result = path.toUri();
            Assert.assertThat((Object)result.getScheme(), (Matcher)CoreMatchers.is((Object)scheme));
            assert (!result.isOpaque());
            try {
                Assert.assertThat((Object)path.getFileSystem().provider().getScheme(), (Matcher)CoreMatchers.is((Object)scheme));
                if (succeeds) continue;
                Assert.fail();
            }
            catch (ServiceConfigurationError ex) {
                if (!succeeds) continue;
                throw ex;
            }
        }
    }

    @Test
    public void testResolve() {
        if ('\\' == File.separatorChar) {
            for (Object[] params : new Object[][]{{"x", "c:/foo", "c:/foo", ROOT_DIRECTORY + "c:/foo"}, {"x", "//foo/bar/baz", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"x", "///foo//bar//baz//", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
                TPathTest.assertResolve(params);
            }
        }
        for (Object[] params : new Object[][]{{"", "/", "/", ROOT_DIRECTORY}, {"x", "/foo", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/bar", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo//bar//", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo/..", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo/../", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo.mok/bar", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo.mok/bar/", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo/bar.mok", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo/bar.mok/", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo.mok/bar.mok", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"x", "/foo.mok/bar.mok/", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"/", "", "/", ROOT_DIRECTORY}, {"/", "foo", "/foo", ROOT_DIRECTORY + "foo"}, {"/", "foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"/", ".", "/", ROOT_DIRECTORY}, {"/", "./", "/", ROOT_DIRECTORY}, {"", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {".", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar", "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"foo", "bar/", "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"", "bar/..", "bar/..", CURRENT_DIRECTORY}, {"", "bar/../", "bar/..", CURRENT_DIRECTORY}, {"foo.mok", "bar", "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo.mok", "bar/", "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo", "bar.mok", "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo", "bar.mok/", "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo.mok", "bar.mok", "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"foo.mok", "bar.mok/", "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"foo.mok", "..", "", CURRENT_DIRECTORY}, {"foo.mok", "../", "", CURRENT_DIRECTORY}, {"foo.mok", "../bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "../bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}}) {
            TPathTest.assertResolve(params);
        }
    }

    private static void assertResolve(Object ... params) {
        TPath parent = new TPath(params[0].toString(), new String[0]);
        String first = params[1].toString();
        String name = params[2].toString();
        FsPath address = FsPath.create((URI)URI.create(params[3].toString()));
        TPath member = new TPath(first, new String[0]);
        TPath path = parent.resolve((Path)member);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)address.getMountPoint()));
        Assert.assertThat((Object)path.getEntryName(), (Matcher)CoreMatchers.equalTo((Object)address.getEntryName()));
    }

    @Test
    public void testResolveSibling() {
        if ('\\' == File.separatorChar) {
            for (Object[] params : new Object[][]{{"x", "c:/foo", "c:/foo", ROOT_DIRECTORY + "c:/foo"}, {"x", "//foo/bar/baz", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"x", "///foo//bar//baz//", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
                TPathTest.assertResolveSibling(params);
            }
        }
        for (Object[] params : new Object[][]{{"", "/", "/", ROOT_DIRECTORY}, {"x", "/foo", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/bar", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo//bar//", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo/..", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo/../", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo.mok/bar", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo.mok/bar/", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo/bar.mok", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo/bar.mok/", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo.mok/bar.mok", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"x", "/foo.mok/bar.mok/", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"/", "", "", CURRENT_DIRECTORY}, {"/", "foo", "foo", CURRENT_DIRECTORY + "foo"}, {"/", "foo/", "foo", CURRENT_DIRECTORY + "foo"}, {"/", ".", ".", CURRENT_DIRECTORY}, {"/", "./", ".", CURRENT_DIRECTORY}, {"", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {".", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"", "bar/..", "bar/..", CURRENT_DIRECTORY}, {"", "bar/../", "bar/..", CURRENT_DIRECTORY}, {"foo.mok", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {"foo.mok", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo", "bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", ".", ".", CURRENT_DIRECTORY}, {"foo.mok", "./", ".", CURRENT_DIRECTORY}, {"foo.mok", "./bar.mok", "./bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "./bar.mok/", "./bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}}) {
            TPathTest.assertResolveSibling(params);
        }
    }

    private static void assertResolveSibling(Object ... params) {
        TPath parent = new TPath(params[0].toString(), new String[0]);
        String first = params[1].toString();
        String name = params[2].toString();
        FsPath address = FsPath.create((URI)URI.create(params[3].toString()));
        TPath member = new TPath(first, new String[0]);
        TPath path = parent.resolveSibling((Path)member);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)address.getMountPoint()));
        Assert.assertThat((Object)path.getEntryName(), (Matcher)CoreMatchers.equalTo((Object)address.getEntryName()));
    }

    @Test
    public void testGetParent() {
        if ('\\' == File.separatorChar) {
            for (String[] params : new String[][]{{"c:/", null}, {"c:/foo", "c:/"}, {"c:/foo/", "c:/"}}) {
                TPathTest.assertGetParent(params);
            }
        }
        for (String[] params : new String[][]{{"", null}, {".", null}, {"./", null}, {"..", null}, {"../", null}, {"foo", null}, {"foo/", null}, {"foo/.", "foo"}, {"foo/./", "foo"}, {"foo/..", "foo"}, {"foo/../", "foo"}, {"./foo", null}, {"./foo/", null}, {"../foo", ".."}, {"../foo/", ".."}, {"/", null}, {"/foo", "/"}, {"/foo/", "/"}, {"/foo/..", "/foo"}, {"/foo/../", "/foo"}}) {
            TPathTest.assertGetParent(params);
        }
    }

    private static void assertGetParent(String ... params) {
        TPath path = new TPath(params[0], new String[0]);
        TPath parent = null == params[1] ? null : new TPath(params[1], new String[0]);
        Assert.assertThat((Object)path.getParent(), (Matcher)CoreMatchers.is((Object)parent));
    }

    @Test
    public void testGetRoot() {
        if ('\\' == File.separatorChar) {
            for (String[] params : new String[][]{{"c://", "c:/"}, {"c:/", "c://"}, {"c:/foo", "c:/"}, {"//foo/bar/", "//foo/bar/"}, {"//foo/bar/baz", "//foo/bar/"}}) {
                TPathTest.assertGetRoot(params);
            }
        }
        for (String[] params : new String[][]{{"", null}, {"foo", null}, {"/", "/"}, {"/foo", "/"}}) {
            TPathTest.assertGetRoot(params);
        }
    }

    private static void assertGetRoot(String ... params) {
        String test = params[0];
        String root = params[1];
        TPath testPath = new TPath(test, new String[0]);
        TPath rootPath = root == null ? null : new TPath(root, new String[0]);
        Assert.assertThat((Object)testPath.getRoot(), (Matcher)CoreMatchers.is((Object)rootPath));
    }

    @Test
    public void testGetFileName() {
        if ('\\' == File.separatorChar) {
            for (String[] params : new String[][]{{"c:/", null}, {"c:/foo", "foo"}, {"c:/foo/bar", "bar"}, {"//foo/bar/", null}, {"//foo/bar/baz", "baz"}}) {
                TPathTest.assertGetFileName(params);
            }
        }
        for (String[] params : new String[][]{{"", null}, {"foo", "foo"}, {"foo/bar", "bar"}, {"/", null}, {"/foo", "foo"}, {"/foo/bar", "bar"}}) {
            TPathTest.assertGetFileName(params);
        }
    }

    private static void assertGetFileName(String ... params) {
        String test = params[0];
        String fileName = params[1];
        TPath testPath = new TPath(test, new String[0]);
        TPath fileNamePath = fileName == null ? null : new TPath(fileName, new String[0]);
        Assert.assertThat((Object)testPath.getFileName(), (Matcher)CoreMatchers.is((Object)fileNamePath));
    }

    @Test
    public void testCutTrailingSeparators() {
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"c://", (int)3), (Matcher)CoreMatchers.is((Object)"c:/"));
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"///", (int)2), (Matcher)CoreMatchers.is((Object)"//"));
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"//", (int)1), (Matcher)CoreMatchers.is((Object)"/"));
    }

    @Test
    public void testElements() {
        if ('\\' == File.separatorChar) {
            for (Object[] params : new Object[][]{{"c:/foo", NO_MORE}, {"c:/foo", new String[]{"bar"}}, {"//foo/bar/boom", NO_MORE}, {"//foo/bar/boom", new String[]{"bang"}}}) {
                TPathTest.assertElements(params);
            }
        }
        for (Object[] params : new Object[][]{{"", null}, {"foo", NO_MORE}, {"foo", new String[]{"bar"}}, {"/", null}, {"/foo", NO_MORE}, {"/foo", new String[]{"bar"}}}) {
            TPathTest.assertElements(params);
        }
    }

    private static void assertElements(Object ... params) {
        int count;
        TPath path;
        String first = params[0].toString();
        String[] more = (String[])params[1];
        if (null == more) {
            path = new TPath(first, new String[0]);
            count = 0;
        } else {
            path = new TPath(first, more);
            count = more.length + 1;
        }
        Assert.assertThat((Object)path.getNameCount(), (Matcher)CoreMatchers.is((Object)count));
        Iterator it = path.iterator();
        if (0 < count--) {
            Assert.assertThat((Object)path.getName(0).toString(), (Matcher)CoreMatchers.is((Object)TPathTest.stripPrefix(first)));
            Assert.assertThat((Object)((Path)it.next()).toString(), (Matcher)CoreMatchers.is((Object)TPathTest.stripPrefix(first)));
            int i = 0;
            while (i < count) {
                String m = more[i];
                String p = path.getName(++i).toString();
                Assert.assertThat((Object)p, (Matcher)CoreMatchers.is((Object)m));
                Assert.assertThat((Object)((Path)it.next()).toString(), (Matcher)CoreMatchers.is((Object)m));
            }
        }
        Assert.assertThat((Object)it.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static String stripPrefix(String s) {
        return s.substring(Paths.prefixLength((String)s, (char)'/', (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfiguration() {
        TPath file;
        TPath directory = new TPath("", new String[0]);
        TPath archive = directory.resolve("archive.mok");
        TConfig config = TConfig.push();
        try {
            config.setArchiveDetector(TArchiveDetector.NULL);
            file = directory.resolve("archive.mok");
        }
        finally {
            config.close();
        }
        assert (archive.getArchiveDetector() == this.getDetector());
        assert (archive.isArchive());
        assert (file.getArchiveDetector() == TArchiveDetector.NULL);
        assert (!file.isArchive());
    }
}

