/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.io.FileBusyException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.nio.file.TFileSystemProvider;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.nio.file.TestBase;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputClosedException;
import de.schlichtherle.truezip.socket.spi.ByteArrayIOPoolService;
import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public abstract class TPathTestSuite
extends TestBase {
    private static final Logger logger = Logger.getLogger(TPathTestSuite.class.getName());
    private static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    private static final byte[] DATA = new byte[1024];
    protected static final IOPoolProvider IO_POOL_PROVIDER;
    private final FsScheme scheme;
    private Path temp;
    private TPath archive;
    private byte[] data;
    private static final String[] MEMBERS;

    protected TPathTestSuite(FsScheme scheme, FsArchiveDriver<?> driver) {
        super(new TArchiveDetector(scheme.toString(), driver));
        if (null == driver) {
            throw new NullPointerException();
        }
        this.scheme = scheme;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.temp = this.createTempFile();
        Files.delete(this.temp);
        this.archive = new TPath(this.temp);
        this.data = (byte[])DATA.clone();
    }

    private Path createTempFile() throws IOException {
        return Files.createTempFile(TEMP_FILE_PREFIX, this.getSuffix(), new FileAttribute[0]).toRealPath(new LinkOption[0]);
    }

    protected final TPath getArchive() {
        return this.archive;
    }

    protected final String getSuffix() {
        return "." + this.scheme;
    }

    protected final byte[] getData() {
        return (byte[])this.data.clone();
    }

    protected final int getDataLength() {
        return this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            this.archive = null;
            try {
                TFileSystemProvider.umount();
            }
            catch (FsSyncException ex) {
                logger.log(Level.WARNING, ex.toString(), ex);
            }
            if (Files.exists(this.temp, new LinkOption[0])) {
                try {
                    Files.delete(this.temp);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "{0} (could not delete)", this.temp);
                }
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected static TPath newNonArchivePath(TPath path) {
        return path.getNonArchivePath();
    }

    private static void gc() {
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TPathTestSuite.class.getName()).log(Level.WARNING, "Current thread was interrupted while waiting!", ex);
        }
    }

    @Test
    public final void testFalsePositives() throws IOException {
        this.assertFalsePositive(this.archive);
        TPath entry = this.archive.resolve("entry" + this.getSuffix());
        Files.createDirectory((Path)this.archive, new FileAttribute[0]);
        this.assertFalsePositive(entry);
        Files.delete((Path)this.archive);
        Files.createDirectory((Path)TPathTestSuite.newNonArchivePath(this.archive), new FileAttribute[0]);
        this.assertFalsePositive(entry);
        Files.delete((Path)this.archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFalsePositive(TPath file) throws IOException {
        block24: {
            block23: {
                assert (file.isArchive());
                OutputStream out = Files.newOutputStream((Path)file, new OpenOption[0]);
                try {
                    out.write(this.data);
                }
                finally {
                    out.close();
                }
                out = Files.newOutputStream((Path)file, new OpenOption[0]);
                try {
                    out.write(this.data);
                }
                finally {
                    out.close();
                }
                Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
                Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
                Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
                Assert.assertEquals((long)this.data.length, (long)Files.size((Path)file));
                Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
                InputStream in = Files.newInputStream((Path)file, new OpenOption[0]);
                try {
                    byte[] buf = new byte[this.data.length];
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)0, (byte[])buf, (int)0, (int)in.read(buf)));
                }
                finally {
                    in.close();
                }
                this.assertRm(file);
                Files.createDirectory((Path)TPathTestSuite.newNonArchivePath(file), new FileAttribute[0]);
                Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
                Assert.assertTrue((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
                Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
                Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
                try {
                    Files.newInputStream((Path)this.archive, new OpenOption[0]).close();
                    if ('\\' == File.separatorChar) {
                        Assert.fail();
                    }
                }
                catch (IOException ex) {
                    if ('\\' == File.separatorChar || this.archive.isArchive()) break block23;
                    throw ex;
                }
            }
            try {
                Files.newOutputStream((Path)this.archive, new OpenOption[0]).close();
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.assertRm(file);
            Files.createDirectory((Path)file, new FileAttribute[0]);
            Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
            Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
            try {
                Files.newInputStream((Path)this.archive, new OpenOption[0]).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (IOException ex) {
                if ('\\' == File.separatorChar || this.archive.isArchive() || this.archive.isEntry()) break block24;
                throw ex;
            }
        }
        try {
            Files.newOutputStream((Path)this.archive, new OpenOption[0]).close();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.assertRm(file);
    }

    private void assertRm(TPath file) throws IOException {
        Files.delete((Path)file);
        Assert.assertFalse((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        try {
            Files.size((Path)file);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
        try {
            Files.getLastModifiedTime((Path)file, new LinkOption[0]);
            Assert.fail();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public final void testCreateNewFile() throws IOException {
        this.assertCreateNewPlainFile();
        this.assertCreateNewEnhancedFile();
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewPlainFile() throws IOException {
        Path archive = this.createTempFile();
        Files.delete(archive);
        Path file1 = archive.resolve("test.txt");
        Path file2 = file1.resolve("test.txt");
        try {
            Files.createFile(file1, new FileAttribute[0]);
            Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        this.assertCreateNewFile(archive, file1, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewEnhancedFile() throws IOException {
        TPath file1 = this.archive.resolve("test.txt");
        TPath file2 = file1.resolve("test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                Files.createFile((Path)file1, new FileAttribute[0]);
                Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.assertCreateNewFile((Path)this.archive, (Path)file1, (Path)file2);
        }
        finally {
            config.close();
        }
        this.assertCreateNewFile((Path)this.archive, (Path)file1, (Path)file2);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewFile(Path dir, Path file1, Path file2) throws IOException {
        TPath tdir;
        Assert.assertFalse((boolean)Files.exists(dir, new LinkOption[0]));
        Files.createDirectory(dir, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(dir, new LinkOption[0]));
        if (dir instanceof TPath && ((tdir = (TPath)dir).isArchive() || tdir.isEntry())) {
            Assert.assertEquals((long)0L, (long)Files.size(dir));
        }
        Files.createFile(file1, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(file1, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile(file1, new LinkOption[0]));
        Assert.assertEquals((long)0L, (long)Files.size(file1));
        try {
            Files.createFile(file2, new FileAttribute[0]);
            Assert.fail((String)"Creating a file in another file should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Files.delete(file1);
        Assert.assertFalse((boolean)Files.exists(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(file1, new LinkOption[0]));
        try {
            Files.size(file1);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
        Files.delete(dir);
        Assert.assertFalse((boolean)Files.exists(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(dir, new LinkOption[0]));
        try {
            Files.size(dir);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDirectoryOperations() throws IOException {
        try {
            String[] names = new String[]{"inner" + this.getSuffix(), "dir"};
            TPath file = this.archive;
            for (int i = 0; i <= names.length; ++i) {
                TPath file2 = TPathTestSuite.newNonArchivePath(file);
                Files.createDirectory((Path)file2, new FileAttribute[0]);
                this.assertIllegalDirectoryOperations(file2);
                Files.delete((Path)file2);
                Files.createDirectory((Path)file, new FileAttribute[0]);
                this.assertIllegalDirectoryOperations(file);
                if (i >= names.length) continue;
                file = file.resolve(names[i]);
            }
        }
        finally {
            this.archive.toFile().rm_r();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIllegalDirectoryOperations(TPath dir) throws IOException {
        block13: {
            assert (Files.isDirectory((Path)dir, new LinkOption[0]));
            try {
                Files.newInputStream((Path)dir, new OpenOption[0]).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (IOException ex) {
                if ('\\' == File.separatorChar || dir.isArchive() || dir.isEntry()) break block13;
                throw ex;
            }
        }
        try {
            Files.newOutputStream((Path)dir, new OpenOption[0]).close();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        Path tmp = Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]);
        try {
            try {
                Files.copy(tmp, (Path)dir, new CopyOption[0]);
                Assert.fail();
            }
            catch (FileAlreadyExistsException expected) {
                // empty catch block
            }
            try {
                Files.copy((Path)dir, tmp, new CopyOption[0]);
                Assert.fail();
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            Files.delete(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testStrictFileOutputStream() throws IOException {
        TPath file = this.archive.resolve("test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                this.assertFileOutputStream(file);
                Assert.fail((String)"Creating ghost directories should not be allowed when Path.isLenient() is false!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Files.createDirectory((Path)this.archive, new FileAttribute[0]);
            this.assertFileOutputStream(file);
            Files.delete((Path)this.archive);
        }
        finally {
            config.close();
        }
    }

    @Test
    public final void testLenientFileOutputStream() throws IOException {
        TPath file = this.archive.resolve("dir/inner" + this.getSuffix() + "/dir/test.txt");
        this.assertFileOutputStream(file);
        try {
            Files.delete((Path)this.archive);
            Assert.fail((String)"directory not empty");
        }
        catch (IOException expected) {
            // empty catch block
        }
        TFileSystemProvider.umount();
        Files.delete((Path)TPathTestSuite.newNonArchivePath(this.archive));
        Assert.assertFalse((boolean)Files.exists((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)this.archive, new LinkOption[0]));
        try {
            Files.size((Path)this.archive);
            Assert.fail();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFileOutputStream(TPath file) throws IOException {
        byte[] message = "Hello World!\r\n".getBytes();
        OutputStream out = Files.newOutputStream((Path)file, new OpenOption[0]);
        try {
            Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
            out.write(message);
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
            out.flush();
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        Assert.assertEquals((long)message.length, (long)Files.size((Path)file));
        try {
            Files.createFile((Path)file, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        Assert.assertEquals((long)message.length, (long)Files.size((Path)file));
        Files.delete((Path)file);
        Assert.assertFalse((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        try {
            Files.size((Path)file);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testBusyFileInputStream() throws IOException {
        TPath file1 = this.archive.resolve("file1");
        TPath file2 = this.archive.resolve("file2");
        Files.createFile((Path)file1, new FileAttribute[0]);
        TFileSystemProvider.umount();
        Files.createFile((Path)file2, new FileAttribute[0]);
        InputStream in1 = Files.newInputStream((Path)file1, new OpenOption[0]);
        try {
            block15: {
                Files.newInputStream((Path)file2, new OpenOption[0]);
                TPathTestSuite.gc();
                try {
                    Files.copy(in1, (Path)file2, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (FsSyncWarningException ex) {
                    Assert.fail((String)"The garbage collector hasn't been collecting an open stream. If this is only happening occasionally, you can safely ignore it.");
                }
                try {
                    TFileSystemProvider.umount();
                    Assert.fail((String)"Expected warning exception when synchronizing a busy archive file!");
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FileBusyException) break block15;
                    throw ex;
                }
            }
            Assert.assertTrue((boolean)Files.isRegularFile((Path)file2, new LinkOption[0]));
            try {
                Files.copy(in1, (Path)file2, StandardCopyOption.REPLACE_EXISTING);
                Assert.fail((String)"Expected exception when reading from entry input stream of an unmounted archive file!");
            }
            catch (IOException expected) {
                // empty catch block
            }
            Files.newInputStream((Path)file1, new OpenOption[0]);
            TPathTestSuite.gc();
            try {
                TFileSystemProvider.umount();
            }
            catch (FsSyncWarningException ex) {
                Assert.fail((String)"The garbage collector hasn't been collecting an open stream. If this is only happening occasionally, you can safely ignore it.");
            }
            Files.delete((Path)TPathTestSuite.newNonArchivePath(this.archive));
        }
        finally {
            in1.close();
        }
        try {
            Files.delete((Path)file2);
            Assert.fail((String)"already deleted externally");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)Files.exists((Path)file2, new LinkOption[0]));
        try {
            Files.delete((Path)file1);
            Assert.fail((String)"already deleted externally");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)Files.exists((Path)file1, new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testBusyFileOutputStream() throws IOException {
        OutputStream out;
        TPath file2;
        TPath file1;
        block20: {
            block19: {
                file1 = this.archive.resolve("file1");
                file2 = this.archive.resolve("file2");
                out = Files.newOutputStream((Path)file1, new OpenOption[0]);
                try {
                    Streams.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                out = Files.newOutputStream((Path)file2, new OpenOption[0]);
                try {
                    Streams.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                TFileSystemProvider.umount();
                out = Files.newOutputStream((Path)file1, new OpenOption[0]);
                Streams.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                try {
                    Files.newOutputStream((Path)file1, new OpenOption[0]).close();
                    Assert.fail((String)"Expected synchronization exception when overwriting an unsynchronized entry of a busy archive file!");
                }
                catch (FsSyncException ex) {
                    if (ex.getCause() instanceof FileBusyException) break block19;
                    throw ex;
                }
            }
            try {
                Files.newOutputStream((Path)file2, new OpenOption[0]).close();
            }
            catch (FsSyncException ex) {
                if (!(ex.getCause() instanceof FileBusyException)) {
                    throw ex;
                }
                logger.warning("This archive driver does NOT support concurrent writing of different entries in the same archive file.");
            }
            Streams.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
            try {
                TFileSystemProvider.umount();
                Assert.fail((String)"Expected warning exception when synchronizing a busy archive file!");
            }
            catch (FsSyncWarningException ex) {
                if (ex.getCause() instanceof FileBusyException) break block20;
                throw ex;
            }
        }
        try {
            Streams.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
            Assert.fail((String)"Expected exception when writing to entry output stream of an unmounted archive file!");
        }
        catch (OutputClosedException expected) {
            // empty catch block
        }
        out.close();
        out = Files.newOutputStream((Path)file1, new OpenOption[0]);
        out = null;
        TPathTestSuite.gc();
        try {
            TFileSystemProvider.umount();
        }
        catch (FsSyncWarningException ex) {
            Assert.fail((String)"The garbage collector hasn't been collecting an open stream. If this is only happening occasionally, you can safely ignore it.");
        }
        Files.delete((Path)file2);
        Assert.assertFalse((boolean)Files.exists((Path)file2, new LinkOption[0]));
        Files.delete((Path)file1);
        Assert.assertFalse((boolean)Files.exists((Path)file1, new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testMkdir() throws IOException {
        TPath dir1 = this.archive;
        TPath dir2 = dir1.resolve("dir");
        TPath dir3 = dir2.resolve("inner" + this.getSuffix());
        TPath dir4 = dir3.resolve("dir");
        TPath dir5 = dir4.resolve("nuts" + this.getSuffix());
        TPath dir6 = dir5.resolve("dir");
        assert (TConfig.get().isLenient());
        Files.createDirectory((Path)dir6, new FileAttribute[0]);
        try {
            Files.createDirectory((Path)dir6, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir5, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir4, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir3, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir2, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir1, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        Files.delete((Path)dir6);
        Files.delete((Path)dir5);
        Files.delete((Path)dir4);
        Files.delete((Path)dir3);
        Files.delete((Path)dir2);
        Files.delete((Path)dir1);
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                Files.createDirectory((Path)dir6, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir5, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir4, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir3, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir2, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            Files.createDirectory((Path)dir1, new FileAttribute[0]);
            Files.createDirectory((Path)dir2, new FileAttribute[0]);
            Files.createDirectory((Path)dir3, new FileAttribute[0]);
            Files.createDirectory((Path)dir4, new FileAttribute[0]);
            Files.createDirectory((Path)dir5, new FileAttribute[0]);
            Files.createDirectory((Path)dir6, new FileAttribute[0]);
        }
        finally {
            config.close();
        }
        Files.delete((Path)dir6);
        Files.delete((Path)dir5);
        Files.delete((Path)dir4);
        Files.delete((Path)dir3);
        Files.delete((Path)dir2);
        Files.delete((Path)dir1);
    }

    @Test
    public final void testDirectoryTree() throws IOException {
        this.assertDirectoryTree(new TPath(System.getProperty("java.io.tmpdir"), new String[0]), new TPath("dir/inner" + this.getSuffix() + "/dir/outer" + this.getSuffix() + "/" + this.archive.getFileName(), new String[0]));
    }

    private void assertDirectoryTree(TPath basePath, TPath reversePath) throws IOException {
        if (reversePath == null) {
            TPath test = basePath.resolve("test.txt");
            this.assertFileOutputStream(test);
            return;
        }
        TPath member = basePath.resolve((Path)reversePath.getFileName());
        boolean created = false;
        try {
            Files.createDirectory((Path)member, new FileAttribute[0]);
            created = true;
        }
        catch (FileAlreadyExistsException ex) {
            // empty catch block
        }
        TPath children = reversePath.getParent();
        this.assertDirectoryTree(member, children);
        this.assertListFiles(basePath, member.getFileName().toString());
        Assert.assertTrue((boolean)Files.exists((Path)member, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory((Path)member, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)member, new LinkOption[0]));
        if (member.isArchive()) {
            Assert.assertEquals((long)0L, (long)Files.size((Path)member));
        }
        if (created) {
            Files.delete((Path)member);
            Assert.assertFalse((boolean)Files.exists((Path)member, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isDirectory((Path)member, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isRegularFile((Path)member, new LinkOption[0]));
            try {
                Files.size((Path)member);
                Assert.fail();
            }
            catch (NoSuchFileException expected) {
                // empty catch block
            }
        }
    }

    private void assertListFiles(TPath dir, String entry) throws IOException {
        Path[] files = TPathTestSuite.listFiles((Path)dir);
        boolean found = false;
        for (Path file : files) {
            if (!file.getFileName().toString().equals(entry)) continue;
            found = true;
        }
        if (!found) {
            Assert.fail((String)("No such entry: " + entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path[] listFiles(Path dir) throws IOException {
        Path[] pathArray;
        DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
        try {
            LinkedList<Path> list = new LinkedList<Path>();
            for (Path path : stream) {
                list.add(path);
            }
            pathArray = list.toArray(new Path[list.size()]);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (NotDirectoryException ex) {
                return null;
            }
        }
        stream.close();
        return pathArray;
    }

    @Test
    public final void testInputOutput() throws IOException {
        this.assertInputOutput(this.archive);
        TPath archiveTest = this.archive.resolve("test");
        this.assertInputOutput(archiveTest);
        TPath archive2 = this.archive.resolve("inner" + this.getSuffix());
        TPath archive2Test = archive2.resolve("test");
        this.assertInputOutput(archive2Test);
        Files.delete((Path)archive2);
        Files.delete((Path)this.archive);
    }

    private void assertInputOutput(TPath file) throws IOException {
        this.assertInput(file);
        this.assertOutput(file);
        Files.delete((Path)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInput(TPath file) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        try {
            Files.copy(in, (Path)file, new CopyOption[0]);
        }
        finally {
            ((InputStream)in).close();
        }
        Assert.assertEquals((long)this.data.length, (long)Files.size((Path)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOutput(TPath file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.data.length);
        try {
            Files.copy((Path)file, out);
            Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
        }
        finally {
            out.close();
        }
    }

    @Test
    public final void testCopyContainingOrSameFiles() throws IOException {
        assert (!Files.exists((Path)this.archive, new LinkOption[0]));
        TPath dir = this.archive.getParent();
        Assert.assertNotNull((Object)dir);
        TPath entry = this.archive.resolve("entry");
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        Files.copy(new ByteArrayInputStream(this.data), (Path)entry, new CopyOption[0]);
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        this.archive.toFile().rm_r();
    }

    private void assertCopyContainingOrSameFiles0(TPath a, TPath b) throws IOException {
        this.assertCopyContainingOrSameFiles1(a, b);
        this.assertCopyContainingOrSameFiles1(a.toRealPath(new LinkOption[0]), b);
        this.assertCopyContainingOrSameFiles1(a, b.toRealPath(new LinkOption[0]));
        this.assertCopyContainingOrSameFiles1(a.toRealPath(new LinkOption[0]), b.toRealPath(new LinkOption[0]));
    }

    private void assertCopyContainingOrSameFiles1(TPath a, TPath b) throws IOException {
        try {
            Files.copy((Path)a, (Path)a, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)b, (Path)b, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public final void testCopyDelete() throws IOException {
        String[] names = new String[]{"0" + this.getSuffix(), "1" + this.getSuffix()};
        Files.createDirectory((Path)this.archive, new FileAttribute[0]);
        this.assertCopyDelete(this.archive, names, 0);
        Files.delete((Path)this.archive);
        Files.createDirectory((Path)TPathTestSuite.newNonArchivePath(this.archive), new FileAttribute[0]);
        this.assertCopyDelete(this.archive, names, 0);
        Files.delete((Path)this.archive);
    }

    private void assertCopyDelete(TPath parent, String[] names, int off) throws IOException {
        if (off >= names.length) {
            return;
        }
        TPath dir = parent.resolve(names[off]);
        Files.createDirectory((Path)dir, new FileAttribute[0]);
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        Files.delete((Path)dir);
        Files.createDirectory((Path)TPathTestSuite.newNonArchivePath(dir), new FileAttribute[0]);
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        Files.delete((Path)dir);
    }

    private void assertCopyDelete(TPath parent, TPath dir) throws IOException {
        TPath parentFile = parent.resolve("file");
        TPath parentArchive = parent.resolve("archive" + this.getSuffix());
        TPath dirFile = dir.resolve("file");
        TPath dirArchive = dir.resolve("archive" + this.getSuffix());
        this.assertCopyDelete0(dirFile, dirArchive);
        this.assertCopyDelete0(dirFile, parentFile);
        this.assertCopyDelete0(dirFile, parentArchive);
        this.assertCopyDelete0(parentFile, dirFile);
        this.assertCopyDelete0(parentFile, dirArchive);
        this.assertCopyDelete0(parentArchive, dirFile);
        this.assertCopyDelete0(parentArchive, dirArchive);
        this.assertCopyDelete0(dirArchive, dirFile);
        this.assertCopyDelete0(dirArchive, parentFile);
        this.assertCopyDelete0(dirArchive, parentArchive);
    }

    private void assertCopyDelete0(TPath a, TPath b) throws IOException {
        this.assertCopyDelete0(a, b, 4000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCopyDelete0(TPath a, TPath b, long granularity) throws IOException {
        long time = System.currentTimeMillis();
        OutputStream out = Files.newOutputStream((Path)a, new OpenOption[0]);
        try {
            out.write(this.data);
        }
        finally {
            out.close();
        }
        Files.setLastModifiedTime((Path)a, FileTime.fromMillis(time - granularity));
        Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)Files.size((Path)b), (Matcher)CoreMatchers.is((Object)Files.size((Path)a)));
        Assert.assertThat((Object)Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis())));
        Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        Assert.assertThat((Object)Files.size((Path)b), (Matcher)CoreMatchers.is((Object)Files.size((Path)a)));
        long almd = Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() / granularity * granularity;
        long blmd = Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() / granularity * granularity;
        long almu = (Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        long blmu = (Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((almd == blmd || almu == blmu ? 1 : 0) != 0);
        Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)Files.size((Path)a), (Matcher)CoreMatchers.is((Object)Files.size((Path)b)));
        Assert.assertThat((Object)Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis())));
        Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        Assert.assertThat((Object)Files.size((Path)a), (Matcher)CoreMatchers.is((Object)Files.size((Path)b)));
        almd = Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() / granularity * granularity;
        blmd = Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() / granularity * granularity;
        almu = (Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        blmu = (Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((almd == blmd || almu == blmu ? 1 : 0) != 0);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(this.data.length);
        Files.copy((Path)a, out2);
        Assert.assertTrue((boolean)Arrays.equals(this.data, out2.toByteArray()));
        Files.delete((Path)a);
        Files.delete((Path)b);
    }

    @Test
    public final void testListPerformance() throws IOException {
        int j;
        int i;
        Files.createDirectory((Path)this.archive, new FileAttribute[0]);
        long time = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            TPath file = this.archive.resolve("" + i);
            Files.createFile((Path)file, new FileAttribute[0]);
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to create {0} archive file entries: {1}ms", new Object[]{i, time});
        time = System.currentTimeMillis();
        for (j = 0; j < 100; ++j) {
            TPathTestSuite.listFiles((Path)this.archive);
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to list these entries {0} times using a nullary FilenameFilter: {1}ms", new Object[]{j, time});
        time = System.currentTimeMillis();
        for (j = 0; j < 100; ++j) {
            TPathTestSuite.listFiles((Path)this.archive);
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to list these entries {0} times using a nullary FileFilter: {1}ms", new Object[]{j, time});
        try {
            Files.delete((Path)this.archive);
            Assert.fail((String)"directory not empty");
        }
        catch (IOException expected) {
            // empty catch block
        }
        TFileSystemProvider.umount();
        Files.delete((Path)TPathTestSuite.newNonArchivePath(this.archive));
        Assert.assertFalse((boolean)Files.exists((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)this.archive, new LinkOption[0]));
        try {
            Files.size((Path)this.archive);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDeleteEntryWithOpenStream() throws IOException {
        TPath entry1 = this.archive.resolve("entry1");
        TPath entry2 = this.archive.resolve("entry2");
        OutputStream out1 = Files.newOutputStream((Path)entry1, new OpenOption[0]);
        try {
            try {
                Files.delete((Path)entry1);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            out1.write(this.data);
            try {
                this.archive.toFile().rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            out1.close();
        }
        OutputStream out2 = Files.newOutputStream((Path)entry2, new OpenOption[0]);
        try {
            try {
                Files.delete((Path)entry2);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            out2.write(this.data);
            try {
                this.archive.toFile().rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            out2.close();
        }
        InputStream in1 = Files.newInputStream((Path)entry1, new OpenOption[0]);
        try {
            ByteArrayOutputStream out;
            InputStream in2 = Files.newInputStream((Path)entry2, new OpenOption[0]);
            try {
                Files.delete((Path)entry2);
                out = new ByteArrayOutputStream(this.data.length);
                try {
                    Streams.cat((InputStream)in2, (OutputStream)out);
                }
                finally {
                    out.close();
                }
                Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
                try {
                    this.archive.toFile().rm_r();
                    Assert.fail();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            finally {
                in2.close();
            }
            try {
                Files.delete((Path)entry1);
                Assert.fail((String)"deleted within archive.toFile().rm_r()");
            }
            catch (IOException expected) {
                // empty catch block
            }
            out = new ByteArrayOutputStream(this.data.length);
            try {
                Streams.cat((InputStream)in1, (OutputStream)out);
            }
            finally {
                out.close();
            }
            Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
            try {
                this.archive.toFile().rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            in1.close();
        }
        this.archive.toFile().rm_r();
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(this.archive), new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testRenameValidArchive() throws IOException {
        PrintStream out = new PrintStream(Files.newOutputStream((Path)this.archive.resolve("entry"), new OpenOption[0]));
        try {
            out.println("Hello World!");
        }
        finally {
            out.close();
        }
        this.assertRenameArchiveToTemp(this.archive);
    }

    @Test
    public final void testRenameFalsePositive() throws IOException {
        TPath tmp = TPathTestSuite.newNonArchivePath(this.archive);
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        Files.copy(in, (Path)tmp, new CopyOption[0]);
        this.assertRenameArchiveToTemp(this.archive);
    }

    private void assertRenameArchiveToTemp(TPath archive) throws IOException {
        assert (archive.isArchive());
        assert (!archive.isEntry());
        TPath tmp = new TPath(Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]));
        Files.delete((Path)tmp);
        Assert.assertFalse((boolean)Files.exists((Path)tmp, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(tmp), new LinkOption[0]));
        archive.toFile().mv((File)tmp.toFile());
        Assert.assertFalse((boolean)Files.exists((Path)archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(archive), new LinkOption[0]));
        tmp.toFile().rm_r();
        Assert.assertFalse((boolean)Files.exists((Path)tmp, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(tmp), new LinkOption[0]));
    }

    @Test
    public final void testRenameRecursively() throws IOException {
        TPath temp = new TPath(this.createTempFile());
        TPath archive2 = this.archive.resolve("inner" + this.getSuffix());
        TPath archive3 = archive2.resolve("nuts" + this.getSuffix());
        TPath archive1a = this.archive.resolve("a");
        TPath archive1b = this.archive.resolve("b");
        TPath archive2a = archive2.resolve("a");
        TPath archive2b = archive2.resolve("b");
        TPath archive3a = archive3.resolve("a");
        TPath archive3b = archive3.resolve("b");
        Files.delete((Path)temp);
        this.assertInput(archive1a);
        for (int i = 2; i >= 1; --i) {
            this.assertRenameTo(archive1a, archive1b);
            this.assertRenameTo(archive1b, archive2a);
            this.assertRenameTo(archive2a, archive2b);
            this.assertRenameTo(archive2b, archive3a);
            this.assertRenameTo(archive3a, archive3b);
            this.assertRenameTo(archive3b, archive3a);
            this.assertRenameTo(archive3a, archive2b);
            this.assertRenameTo(archive2b, archive2a);
            this.assertRenameTo(archive2a, archive1b);
            this.assertRenameTo(archive1b, archive1a);
        }
        this.assertRenameTo(this.archive, temp);
        this.assertRenameTo(temp, this.archive);
        Files.delete((Path)archive3);
        Files.delete((Path)archive2);
        this.assertOutput(archive1a);
        Files.delete((Path)archive1a);
        Files.delete((Path)this.archive);
    }

    private void assertRenameTo(TPath src, TPath dst) throws IOException {
        Assert.assertTrue((boolean)Files.exists((Path)src, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)dst, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(dst), new LinkOption[0]));
        assert (TConfig.get().isLenient());
        src.toFile().mv((File)dst.toFile());
        Assert.assertFalse((boolean)Files.exists((Path)src, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)TPathTestSuite.newNonArchivePath(src), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists((Path)dst, new LinkOption[0]));
    }

    @Test
    public final void testList() throws IOException {
        Path dir = this.createTempFile();
        TPath dir2 = new TPath(dir);
        Files.delete(dir);
        Files.createDirectory(dir, new FileAttribute[0]);
        int i = MEMBERS.length;
        while (--i >= 0) {
            Files.createFile(dir.resolve(MEMBERS[i]), new FileAttribute[0]);
        }
        Object[] files = TPathTestSuite.listFiles(dir);
        Arrays.sort(files);
        this.assertList((Path[])files, dir2);
        dir2.toFile().rm_r();
        Files.createDirectory((Path)dir2, new FileAttribute[0]);
        int i2 = MEMBERS.length;
        while (--i2 >= 0) {
            Files.createFile((Path)dir2.resolve(MEMBERS[i2]), new FileAttribute[0]);
        }
        this.assertList((Path[])files, dir2);
        dir2.toFile().rm_r();
    }

    private void assertList(Path[] refs, TPath dir) throws IOException {
        Object[] files = TPathTestSuite.listFiles((Path)dir);
        Arrays.sort(files);
        Assert.assertEquals((long)refs.length, (long)files.length);
        int l = refs.length;
        for (int i = 0; i < l; ++i) {
            Path ref = refs[i];
            TPath file = (TPath)files[i];
            Assert.assertTrue((!(ref instanceof TPath) ? 1 : 0) != 0);
            Assert.assertEquals((Object)ref.toString(), (Object)file.toString());
            Assert.assertNull((Object)TPathTestSuite.listFiles((Path)file));
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesReading() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesReading(20, 20);
    }

    private void assertMultithreadedSingleArchiveMultipleEntriesReading(final int nEntries, int nThreads) throws Exception {
        class CheckAllEntriesThread
        extends IOThread {
            CheckAllEntriesThread() {
            }

            @Override
            public void work() throws IOException {
                TPathTestSuite.this.assertArchiveEntries(TPathTestSuite.this.archive, nEntries);
            }
        }
        CheckAllEntriesThread thread;
        int i;
        this.createTestArchive(nEntries);
        CheckAllEntriesThread[] threads = new CheckAllEntriesThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new CheckAllEntriesThread();
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new IOException(thread.failure);
        }
        this.archive.toFile().rm_r();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestArchive(int nEntries) throws IOException {
        for (int i = 0; i < nEntries; ++i) {
            TPath entry = new TPath(this.archive + "/" + i, new String[0]);
            OutputStream out = Files.newOutputStream((Path)entry, new OpenOption[0]);
            try {
                out.write(this.data);
                continue;
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertArchiveEntries(TPath archive, int nEntries) throws IOException {
        Path[] entries = TPathTestSuite.listFiles((Path)archive);
        Assert.assertEquals((long)nEntries, (long)entries.length);
        byte[] buf = new byte[4096];
        int l = entries.length;
        for (int i = 0; i < l; ++i) {
            TPath entry = (TPath)entries[i];
            InputStream in = Files.newInputStream((Path)entry, new OpenOption[0]);
            try {
                int read;
                int off = 0;
                while ((read = in.read(buf)) >= 0) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)this.data.length);
                Assert.assertTrue((0 >= in.read(new byte[0]) ? 1 : 0) != 0);
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesWriting() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(this.archive, 20, false);
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(this.archive, 20, true);
    }

    private void assertMultithreadedSingleArchiveMultipleEntriesWriting(final TPath archive, int nThreads, final boolean wait) throws Exception {
        class WritingThread
        extends IOThread {
            final int i;

            WritingThread(int i) {
                this.i = i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void work() throws IOException {
                block10: {
                    OutputStream out;
                    TPath file = archive.resolve(this.i + "");
                    while (true) {
                        try {
                            out = Files.newOutputStream((Path)file, new OpenOption[0]);
                        }
                        catch (FileBusyException busy) {
                            continue;
                        }
                        break;
                    }
                    try {
                        out.write(TPathTestSuite.this.data);
                    }
                    finally {
                        out.close();
                    }
                    try {
                        TFile.umount((boolean)wait, (boolean)false, (boolean)wait, (boolean)false);
                    }
                    catch (FsSyncException ex) {
                        if (!(ex.getCause() instanceof FileBusyException)) {
                            throw ex;
                        }
                        if (!wait) break block10;
                        throw new AssertionError((Object)ex);
                    }
                }
            }
        }
        WritingThread thread;
        int i;
        Assert.assertTrue((boolean)TConfig.get().isLenient());
        WritingThread[] threads = new WritingThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new WritingThread(i);
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new Exception(thread.failure);
        }
        this.assertArchiveEntries(archive, nThreads);
        archive.toFile().rm_r();
    }

    @Test
    public final void testMultithreadedMultipleArchivesSingleEntryWriting() throws Exception {
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(20, false);
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(20, true);
    }

    private void assertMultithreadedMultipleArchivesSingleEntryWriting(int nThreads, final boolean updateIndividually) throws Exception {
        class WritingThread
        extends IOThread {
            WritingThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void work() throws IOException {
                TPath archive = new TPath(TPathTestSuite.this.createTempFile());
                Files.delete((Path)archive);
                TPath file = archive.resolve("entry");
                try {
                    OutputStream out = Files.newOutputStream((Path)file, new OpenOption[0]);
                    try {
                        out.write(TPathTestSuite.this.data);
                    }
                    finally {
                        out.close();
                    }
                    try {
                        if (updateIndividually) {
                            archive.getFileSystem().close();
                        } else {
                            TFile.umount((boolean)false);
                        }
                    }
                    catch (FsSyncException ex) {
                        if (!(ex.getCause() instanceof FileBusyException)) {
                            throw ex;
                        }
                        if (updateIndividually) {
                            throw new AssertionError((Object)ex);
                        }
                    }
                }
                finally {
                    archive.toFile().rm_r();
                }
            }
        }
        WritingThread thread;
        int i;
        Assert.assertTrue((boolean)TConfig.get().isLenient());
        WritingThread[] threads = new WritingThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new WritingThread();
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new Exception(thread.failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrow() throws IOException {
        TPath path = TPathTestSuite.newNonArchivePath(this.archive);
        TPath entry1 = this.archive.resolve("entry1");
        TPath entry2 = this.archive.resolve("entry2");
        TConfig config = TConfig.push();
        try {
            config.setOutputPreferences(BitField.of((Enum)FsOutputOption.CREATE_PARENTS, (Enum[])new FsOutputOption[]{FsOutputOption.STORE, FsOutputOption.GROW}));
            this.assertGrow(entry1);
            this.assertGrow(entry2);
            TFileSystemProvider.umount();
            Assert.assertTrue((Files.size((Path)path) > (long)(2 * this.data.length) ? 1 : 0) != 0);
            this.assertGrow(entry1);
            this.assertGrow(entry2);
            this.assertGrow(entry1);
            this.assertGrow(entry2);
            TFileSystemProvider.umount();
            Assert.assertTrue((Files.size((Path)path) > (long)(6 * this.data.length) ? 1 : 0) != 0);
        }
        finally {
            config.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertGrow(TPath entry) throws IOException {
        OutputStream out = Files.newOutputStream((Path)entry, new OpenOption[0]);
        try {
            out.write(this.data);
        }
        finally {
            out.close();
        }
    }

    static {
        rnd.nextBytes(DATA);
        IO_POOL_PROVIDER = new ByteArrayIOPoolService(4 * DATA.length / 3);
        MEMBERS = new String[]{"A directory member", "Another directory member", "Yet another directory member"};
    }

    private abstract class IOThread
    extends Thread {
        Throwable failure;

        IOThread() {
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            try {
                this.work();
            }
            catch (Throwable exception) {
                this.failure = exception;
            }
        }

        abstract void work() throws IOException;
    }
}

