/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class TPathScanner {
    static final URI SEPARATOR_URI = URI.create("/");
    static final URI DOT_URI = URI.create(".");
    static final URI DOT_DOT_URI = URI.create("..");
    static final String DOT_DOT_SEPARATOR = "../";
    private final TArchiveDetector detector;
    private final Paths.Splitter splitter = new Paths.Splitter('/', false);
    private FsPath root;
    private String memberQuery;
    private final UriBuilder uri = new UriBuilder();

    TPathScanner(TArchiveDetector detector) {
        assert (null != detector);
        this.detector = detector;
    }

    FsPath scan(FsPath parent, URI member) {
        try {
            String mp;
            member = TPathScanner.checkFix(member.normalize());
            while ((mp = member.getPath()).startsWith(DOT_DOT_SEPARATOR)) {
                parent = TPathScanner.parent(parent);
                member = new UriBuilder(member).path(mp.substring(3)).getUri();
            }
            if ("..".equals(mp)) {
                return TPathScanner.parent(parent);
            }
            int mpl = TPathScanner.pathPrefixLength(member);
            if (0 < mpl) {
                URI pu = parent.toHierarchicalUri().resolve(SEPARATOR_URI);
                String ma = member.getAuthority();
                String p = null != ma || mp.startsWith("/") ? mp.substring(0, mpl) : pu.getPath() + mp.substring(0, mpl);
                this.root = new FsPath(new UriBuilder().scheme(pu.getScheme()).authority(ma).path(p).getUri());
                mp = mp.substring(mpl);
            } else {
                this.root = parent;
            }
            this.memberQuery = member.getQuery();
            return this.scan(mp);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static int pathPrefixLength(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        int al = null == a ? 0 : 2 + a.length();
        int pl = Paths.prefixLength((String)ssp, (char)'/', (boolean)true) - al;
        return pl >= 0 ? pl : Paths.prefixLength((String)uri.getPath(), (char)'/', (boolean)false);
    }

    static URI checkFix(URI uri) throws URISyntaxException {
        if (uri.isOpaque()) {
            throw new QuotedUriSyntaxException((Object)uri, "Opaque URI");
        }
        if (null != uri.getFragment()) {
            throw new QuotedUriSyntaxException((Object)uri, "Fragment component defined");
        }
        return TPathScanner.fixChecked(uri);
    }

    static URI fixUnchecked(URI uri) {
        return uri.isOpaque() ? uri : TPathScanner.fixChecked(uri);
    }

    private static URI fixChecked(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        if (null == ssp || null == a && ssp.startsWith("//")) {
            return new UriBuilder(uri).toUri();
        }
        return uri;
    }

    static boolean isAbsolute(URI uri) {
        return uri.isAbsolute() || Paths.isAbsolute((String)uri.getSchemeSpecificPart(), (char)'/');
    }

    @Nullable
    static FsPath parent(FsPath path) throws URISyntaxException {
        FsMountPoint mp = path.getMountPoint();
        FsEntryName en = path.getEntryName();
        if (en.isRoot()) {
            if (null == mp) {
                return null;
            }
            path = mp.getPath();
            if (null != path) {
                return TPathScanner.parent(path);
            }
            URI mpu = mp.toUri();
            URI pu = mpu.resolve(DOT_DOT_URI);
            if (mpu.getRawPath().length() <= pu.getRawPath().length()) {
                return null;
            }
            return new FsPath(pu);
        }
        URI pu = en.toUri().resolve(DOT_URI);
        en = new FsEntryName(pu, FsUriModifier.CANONICALIZE);
        return new FsPath(mp, en);
    }

    private FsPath scan(String path) throws URISyntaxException {
        FsPath mp;
        URI ppu;
        FsPath pp;
        FsEntryName men;
        this.splitter.split(path);
        String ps = this.splitter.getParentPath();
        if (null != ps) {
            men = new FsEntryName(this.uri.path(this.splitter.getMemberName()).getUri(), FsUriModifier.NULL);
            pp = this.scan(ps);
        } else {
            men = new FsEntryName(this.uri.path(path).query(this.memberQuery).getUri(), FsUriModifier.CANONICALIZE);
            pp = this.root;
        }
        if (men.isRoot() || (ppu = pp.toUri()).isOpaque() || !ppu.isAbsolute()) {
            mp = pp.resolve(men);
        } else {
            String pup = ppu.getPath();
            if (!pup.endsWith("/")) {
                ppu = new UriBuilder(ppu).path(pup + '/').getUri();
            }
            mp = new FsPath(new FsMountPoint(ppu), men);
        }
        FsScheme s = this.detector.getScheme(men.toString());
        if (null != s) {
            mp = new FsPath(new FsMountPoint(s, mp), FsEntryName.ROOT);
        }
        return mp;
    }
}

