/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.nio.file.MockTestBase;
import de.schlichtherle.truezip.nio.file.TFileSystem;
import de.schlichtherle.truezip.nio.file.TFileSystemProvider;
import de.schlichtherle.truezip.nio.file.TPath;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public class TFileSystemProviderTest
extends MockTestBase {
    private TFileSystemProvider provider;

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.provider = (TFileSystemProvider)TFileSystemProvider.class.newInstance();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Test
    public void testNewFileSystemFromPath() {
        for (Object[] params : new Object[][]{{"foo.mok", new String[]{"x", "bar.mok", "y"}, "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/x/bar.mok!/"}, {"foo.mok", new String[]{"bar.mok"}, "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"foo.mok", new String[]{"x"}, "mok:" + CURRENT_DIRECTORY + "foo.mok!/"}, {"foo.mok", NO_MORE, "mok:" + CURRENT_DIRECTORY + "foo.mok!/"}, {"foo", new String[]{"x"}, null}, {"foo", NO_MORE, null}}) {
            String first = params[0].toString();
            String[] more = (String[])params[1];
            Path path = Paths.get(first, more);
            FsMountPoint mountPoint = null == params[2] ? null : FsMountPoint.create((URI)URI.create(params[2].toString()), (FsUriModifier)FsUriModifier.CANONICALIZE);
            try {
                TFileSystem fs = this.provider.newFileSystem(path, this.getEnvironment());
                if (null == mountPoint) {
                    Assert.fail();
                }
                Assert.assertThat((Object)fs.getMountPoint(), (Matcher)CoreMatchers.is((Object)mountPoint));
                for (String entry : new String[]{"", "foo", "/", "/foo"}) {
                    Assert.assertThat((Object)fs.getPath(entry, new String[0]).getFileSystem(), (Matcher)CoreMatchers.sameInstance((Object)fs));
                }
            }
            catch (UnsupportedOperationException ex) {
                if (null == mountPoint) continue;
                throw ex;
            }
        }
    }

    @Test
    public void testNewFileSystemFromUri() {
        for (String[] params : new String[][]{{this.provider.getScheme() + ":/foo.mok/x/bar.mok/y/", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/x/bar.mok!/"}, {this.provider.getScheme() + ":/foo.mok/x/bar.mok/y", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/x/bar.mok!/"}, {this.provider.getScheme() + ":/foo.mok/bar.mok/", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {this.provider.getScheme() + ":/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {this.provider.getScheme() + ":/foo.mok/x/", "mok:" + ROOT_DIRECTORY + "foo.mok!/"}, {this.provider.getScheme() + ":/foo.mok/x", "mok:" + ROOT_DIRECTORY + "foo.mok!/"}, {this.provider.getScheme() + ":/foo.mok/", "mok:" + ROOT_DIRECTORY + "foo.mok!/"}, {this.provider.getScheme() + ":/foo.mok", "mok:" + ROOT_DIRECTORY + "foo.mok!/"}, {this.provider.getScheme() + ":/foo/bar/x/", ROOT_DIRECTORY + "foo/bar/"}, {this.provider.getScheme() + ":/foo/bar/x", ROOT_DIRECTORY + "foo/bar/"}, {this.provider.getScheme() + ":/foo/x/", ROOT_DIRECTORY + "foo/"}, {this.provider.getScheme() + ":/foo/x", ROOT_DIRECTORY + "foo/"}, {this.provider.getScheme() + ":/x/", ROOT_DIRECTORY.toString()}, {this.provider.getScheme() + ":/x", ROOT_DIRECTORY.toString()}, {this.provider.getScheme() + ":/", ROOT_DIRECTORY.toString()}}) {
            URI uri = URI.create(params[0]);
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            try {
                TFileSystem fs = this.provider.newFileSystem(uri, this.getEnvironment());
                if (null == mountPoint) {
                    Assert.fail();
                }
                Assert.assertThat((Object)fs.getMountPoint(), (Matcher)CoreMatchers.is((Object)mountPoint));
                for (String entry : new String[]{"", "foo", "/", "/foo"}) {
                    Assert.assertThat((Object)fs.getPath(entry, new String[0]).getFileSystem(), (Matcher)CoreMatchers.sameInstance((Object)fs));
                }
            }
            catch (UnsupportedOperationException ex) {
                if (null == mountPoint) continue;
                throw ex;
            }
        }
    }

    @Test
    public void testGetPath() {
        for (Object[] params : new Object[][]{{"", false}, {"/", false}, {"file:/", false}, {"tpath:/", true}}) {
            TPath path;
            URI uri = URI.create(params[0].toString());
            boolean succeeds = (Boolean)params[1];
            try {
                path = this.provider.getPath(uri);
                if (!succeeds) {
                    Assert.fail();
                }
            }
            catch (IllegalArgumentException ex) {
                if (succeeds) {
                    throw ex;
                }
                return;
            }
            Assert.assertThat((Object)path.getFileSystem().provider(), (Matcher)CoreMatchers.sameInstance((Object)this.provider));
            Assert.assertThat((Object)path.toUri().getScheme(), (Matcher)CoreMatchers.is((Object)this.provider.getScheme()));
        }
    }
}

