/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.file.MockTestBase;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.nio.file.TPathScanner;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public class TPathScannerTest
extends MockTestBase {
    @Test
    public void testScan() throws URISyntaxException {
        if ('\\' == File.separatorChar) {
            for (String[] params : new String[][]{{"file:/", "//foo/bar", "file://foo/bar", "file://foo/"}, {"file:/", "//foo/bar/", "file://foo/bar/", "file://foo/bar/"}, {"file:/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}, {"file:/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}, {"file:///c:/", "//foo/bar", "file://foo/bar", "file://foo/"}, {"file:///c:/", "//foo/bar/", "file://foo/bar/", "file://foo/bar/"}, {"file:///c:/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}, {"file:///c:/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}, {"file://host/share/", "//foo/bar", "file://foo/bar", "file://foo/"}, {"file://host/share/", "//foo/bar/", "file://foo/bar/", "file://foo/bar/"}, {"file://host/share/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}, {"file://host/share/", "c%3A/foo", "file:/c:/foo", "file:/c:/"}}) {
                TPathScannerTest.assertScan(params);
            }
        }
        for (String[] params : new String[][]{{"foo", "bar", "foo/bar", null}, {"foo", "..", "", null}, {"foo/bar", "../..", "", null}, {"scheme:/foo", "..", "scheme:/", "scheme:/"}, {"scheme:/foo/bar", "", "scheme:/foo/bar", "scheme:/foo/"}, {"scheme:/foo/bar", "..", "scheme:/foo/", "scheme:/foo/"}, {"scheme:/foo/bar", "../..", "scheme:/", "scheme:/"}, {"scheme:/foo.mok/bar.mok", "../..", "scheme:/", "scheme:/"}, {"mok:mok:scheme:/foo.mok!/bar.mok!/", "", "mok:mok:scheme:/foo.mok!/bar.mok!/", "mok:mok:scheme:/foo.mok!/bar.mok!/"}, {"mok:mok:scheme:/foo.mok!/bar.mok!/", "..", "mok:scheme:/foo.mok!/", "mok:scheme:/foo.mok!/"}, {"mok:mok:scheme:/foo.mok!/bar.mok!/", "../..", "scheme:/", "scheme:/"}, {"mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "", "mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "mok:mok:scheme:/foo.mok!/x/bar.mok!/"}, {"mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "..", "mok:mok:scheme:/foo.mok!/x/bar.mok!/", "mok:mok:scheme:/foo.mok!/x/bar.mok!/"}, {"mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "../..", "mok:scheme:/foo.mok!/x", "mok:scheme:/foo.mok!/"}, {"mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "../../..", "mok:scheme:/foo.mok!/", "mok:scheme:/foo.mok!/"}, {"mok:mok:scheme:/foo.mok!/x/bar.mok!/y", "../../../..", "scheme:/", "scheme:/"}}) {
            TPathScannerTest.assertScan(params);
        }
    }

    private static void assertScan(String ... params) throws URISyntaxException {
        FsPath parent = new FsPath(new URI(params[0]));
        URI member = new URI(params[1]);
        FsPath path = new FsPath(new URI(params[2]));
        FsMountPoint mountPoint = null == params[3] ? null : new FsMountPoint(new URI(params[3]));
        FsPath result = new TPathScanner(TConfig.get().getArchiveDetector()).scan(parent, member);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)path));
        Assert.assertThat((Object)result.getMountPoint(), (Matcher)CoreMatchers.is((Object)mountPoint));
    }

    @Test
    public void testParent() throws URISyntaxException {
        for (String[] params : new String[][]{{"", null}, {"foo", ""}, {"file:/", null}, {"file:/foo", "file:/"}, {"file:/foo/", "file:/"}, {"file:/foo/bar", "file:/foo/"}, {"file:/foo/bar/", "file:/foo/"}, {"mok:file:/foo!/", "file:/"}, {"mok:file:/foo!/bar", "mok:file:/foo!/"}, {"mok:mok:file:/foo!/bar!/", "mok:file:/foo!/"}, {"mok:mok:file:/foo!/bar!/baz", "mok:mok:file:/foo!/bar!/"}, {"mok:mok:file:/foo!/bar!/baz/boom", "mok:mok:file:/foo!/bar!/baz"}}) {
            FsPath path = new FsPath(new URI(params[0]));
            FsPath parent = params[1] == null ? null : new FsPath(new URI(params[1]));
            Assert.assertThat((Object)TPathScanner.parent((FsPath)path), (Matcher)CoreMatchers.is((Object)parent));
        }
    }
}

