/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TDefaultArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.key.KeyManagerService;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RaesFiles {
    public static void encrypt(String plainFilePath, String raesFilePath) throws IOException {
        RaesFiles.encrypt(plainFilePath, raesFilePath, TFile.getDefaultArchiveDetector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(String plainFilePath, String raesFilePath, TArchiveDetector detector) throws IOException {
        TFile plainFile = RaesFiles.newNonArchiveFile(plainFilePath, detector);
        TFile raesFile = RaesFiles.newNonArchiveFile(raesFilePath, detector);
        KeyManagerRaesParameters params = new KeyManagerRaesParameters((KeyManagerService)KeyManagerLocator.SINGLETON, raesFile.getCanonicalFile().toURI());
        TFileInputStream in = new TFileInputStream((File)plainFile);
        try {
            RaesOutputStream out = RaesOutputStream.getInstance((OutputStream)new TFileOutputStream((File)raesFile, false), (RaesParameters)params);
            TFile.cp((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
    }

    public static void decrypt(String raesFilePath, String plainFilePath, boolean strongAuthentication) throws IOException {
        RaesFiles.decrypt(raesFilePath, plainFilePath, strongAuthentication, TFile.getDefaultArchiveDetector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(String raesFilePath, String plainFilePath, boolean strongAuthentication, TArchiveDetector detector) throws IOException {
        TFile raesFile = RaesFiles.newNonArchiveFile(raesFilePath, detector);
        TFile plainFile = RaesFiles.newNonArchiveFile(plainFilePath, detector);
        KeyManagerRaesParameters params = new KeyManagerRaesParameters((KeyManagerService)KeyManagerLocator.SINGLETON, raesFile.getCanonicalFile().toURI());
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile((File)raesFile);
        try {
            RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance((ReadOnlyFile)rof, (RaesParameters)params);
            if (strongAuthentication) {
                rrof.authenticate();
            }
            ReadOnlyFileInputStream in = new ReadOnlyFileInputStream((ReadOnlyFile)rrof);
            TFileOutputStream out = new TFileOutputStream((File)plainFile, false);
            TFile.cp((InputStream)in, (OutputStream)out);
        }
        finally {
            rof.close();
        }
    }

    private static TFile newNonArchiveFile(String path, TArchiveDetector detector) {
        TFile file = new TFile(path, detector);
        TFile parent = file.getParentFile();
        assert (null != parent) : "expected non-null from context!";
        return new TFile((File)parent, file.getName(), (TArchiveDetector)TDefaultArchiveDetector.NULL);
    }
}

