/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file.app;

import de.schlichtherle.truezip.crypto.raes.param.swing.HurlingWindowFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsStatistics;
import de.schlichtherle.truezip.fs.spi.FsManagerProvider;
import de.schlichtherle.truezip.sample.file.app.SampleManagerProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

abstract class CommandLineUtility {
    protected final PrintStream out;
    protected final PrintStream err;
    protected final ProgressMonitor monitor;

    protected CommandLineUtility() {
        this(System.out, System.err, true);
    }

    protected CommandLineUtility(OutputStream out, OutputStream err, boolean autoFlush) {
        if (null == out || null == err) {
            throw new NullPointerException();
        }
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, autoFlush);
        this.err = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err, autoFlush);
        this.monitor = new ProgressMonitor(this.err);
        CommandLineUtility.configureFeedback();
        CommandLineUtility.configureManagerService();
    }

    private static void configureFeedback() {
        String spec = InvalidKeyFeedback.class.getName();
        String impl = HurlingWindowFeedback.class.getName();
        System.setProperty(spec, System.getProperty(spec, impl));
    }

    private static void configureManagerService() {
        String spec = FsManagerProvider.class.getName();
        String impl = SampleManagerProvider.class.getName();
        System.setProperty(spec, System.getProperty(spec, impl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int run(String[] args) {
        int n;
        try {
            n = this.runChecked(args);
        }
        catch (Throwable throwable) {
            try {
                try {
                    TFile.umount();
                }
                finally {
                    this.monitor.shutdown();
                }
                throw throwable;
            }
            catch (IllegalUsageException ex) {
                this.err.println(ex.getLocalizedMessage());
                return 1;
            }
            catch (IOException ex) {
                this.err.println(ex.getLocalizedMessage());
                return 1;
            }
        }
        try {
            TFile.umount();
        }
        finally {
            this.monitor.shutdown();
        }
        return n;
    }

    public abstract int runChecked(String[] var1) throws IllegalUsageException, IOException;

    protected static final class ProgressMonitor
    extends Thread {
        private final PrintStream err;
        private final Long[] args = new Long[2];
        private final FsStatistics stats;

        ProgressMonitor(PrintStream err) {
            this.setDaemon(true);
            this.setPriority(10);
            this.err = err;
            this.stats = SampleManagerProvider.manager.getStatistics();
        }

        @Override
        public void start() {
            if (this.err == System.err || this.err == System.out) {
                super.start();
            }
        }

        @Override
        public void run() {
            boolean run = false;
            long sleep = 2000L;
            while (true) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException shutdown) {
                    break;
                }
                this.showProgress();
                sleep = 200L;
                run = true;
            }
            if (run) {
                this.showProgress();
                this.err.println();
            }
        }

        private void showProgress() {
            this.args[0] = (this.stats.getTopLevelRead() + 1023L) / 1024L;
            this.args[1] = (this.stats.getTopLevelWritten() + 1023L) / 1024L;
            this.err.print(MessageFormat.format("Top level archive I/O: {0} / {1} KB        \r", this.args));
            this.err.flush();
        }

        private void shutdown() {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interrupted) {
                interrupted.printStackTrace();
            }
        }
    }

    protected static class IllegalUsageException
    extends Exception {
        private static final long serialVersionUID = 1985623981423542464L;

        public IllegalUsageException(String msg) {
            super(msg);
        }
    }
}

