/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.zip.raes;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.sample.zip.raes.KeyManagement;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class KeyManagementTest {
    private static final Logger logger = Logger.getLogger(KeyManagementTest.class.getName());
    private static boolean lenientBackup;
    private static TArchiveDetector detectorBackup;
    private static final String TEMP_FILE_PREFIX = "tzp";
    private static final String TEMP_FILE_SUFFIX = ".tzp";
    private static final Random rnd;
    private static final byte[] DATA;
    private File temp;
    private char[] password;
    private byte[] data;

    @BeforeClass
    public static void setUpClass() {
        lenientBackup = TFile.isLenient();
        detectorBackup = TFile.getDefaultArchiveDetector();
    }

    @Before
    public void setUp() throws IOException {
        TFile.umount();
        this.temp = KeyManagementTest.createTempFile();
        Assert.assertTrue((boolean)this.temp.delete());
        this.password = "secret".toCharArray();
        this.data = (byte[])DATA.clone();
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
    }

    @After
    public void tearDown() {
        try {
            TFile.umount();
        }
        catch (FsSyncException ex) {
            logger.log(Level.WARNING, ex.toString(), ex);
        }
        if (this.temp.exists() && !this.temp.delete()) {
            logger.log(Level.WARNING, "{0} (could not delete)", this.temp);
        }
        TFile.setDefaultArchiveDetector((TArchiveDetector)detectorBackup);
        TFile.setLenient((boolean)lenientBackup);
    }

    @Test
    public void testSetPassword() throws IOException {
        TFile archive = new TFile(this.temp);
        KeyManagement.setPassword((TFile)archive, (char[])this.password);
        this.makeArchive(archive);
    }

    @Test
    public void testSetAllPasswords1() throws IOException {
        KeyManagement.setAllPasswords1((char[])this.password);
        this.makeArchive(new TFile(this.temp));
    }

    @Test
    public void testSetAllPasswords2() throws IOException {
        KeyManagement.setAllPasswords2((char[])this.password);
        this.makeArchive(new TFile(this.temp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeArchive(TFile archive) throws IOException {
        TFileOutputStream out = new TFileOutputStream((File)new TFile((File)archive, "entry"));
        try {
            out.write(this.data);
        }
        finally {
            out.close();
        }
    }

    static {
        rnd = new Random();
        DATA = new byte[1024];
        rnd.nextBytes(DATA);
    }
}

