/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file.app;

import de.schlichtherle.truezip.crypto.raes.param.swing.HurlingWindowFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.file.TApplication;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsStatistics;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.spi.FsManagerService;
import de.schlichtherle.truezip.sample.file.app.SampleManagerService;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

@DefaultAnnotation(value={NonNull.class})
abstract class Application
extends TApplication<RuntimeException> {
    protected final PrintStream out;
    protected final PrintStream err;
    protected final ProgressMonitor monitor;

    protected Application() {
        this(System.out, System.err, true);
    }

    protected Application(OutputStream out, OutputStream err, boolean autoFlush) {
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, autoFlush);
        this.err = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err, autoFlush);
        this.monitor = new ProgressMonitor(this.err);
        String spec = FsManagerService.class.getName();
        String impl = SampleManagerService.class.getName();
        System.setProperty(spec, System.getProperty(spec, impl));
    }

    protected void setup() {
        String spec = InvalidKeyFeedback.class.getName();
        String impl = HurlingWindowFeedback.class.getName();
        System.setProperty(spec, System.getProperty(spec, impl));
    }

    protected final int work(String[] args) {
        try {
            return this.runChecked(args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.err.println(ex.getLocalizedMessage());
            return 1;
        }
    }

    protected abstract int runChecked(String[] var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync() throws FsSyncException {
        try {
            TFile.umount();
        }
        finally {
            this.monitor.shutdown();
        }
    }

    protected static final class ProgressMonitor
    extends Thread {
        private final PrintStream err;
        private final Long[] args = new Long[2];
        private final FsStatistics stats;

        private ProgressMonitor(PrintStream err) {
            this.setDaemon(true);
            this.setPriority(10);
            this.err = err;
            this.stats = SampleManagerService.manager.getStatistics();
        }

        @Override
        public void start() {
            if (this.err == System.err || this.err == System.out) {
                super.start();
            }
        }

        @Override
        public void run() {
            boolean run = false;
            long sleep = 2000L;
            while (true) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException shutdown) {
                    break;
                }
                this.showProgress();
                sleep = 200L;
                run = true;
            }
            if (run) {
                this.showProgress();
                this.err.println();
            }
        }

        private void showProgress() {
            this.args[0] = (this.stats.getTopLevelRead() + 1023L) / 1024L;
            this.args[1] = (this.stats.getTopLevelWritten() + 1023L) / 1024L;
            this.err.print(MessageFormat.format("Top level archive I/O: {0}/{1} KB        \r", this.args));
            this.err.flush();
        }

        private void shutdown() {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interrupted) {
                interrupted.printStackTrace();
            }
        }
    }

    protected static class IllegalUsageException
    extends Exception {
        private static final long serialVersionUID = 1985623981423542464L;

        protected IllegalUsageException(String msg) {
            super(msg);
        }
    }
}

