/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.zip.raes;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.archive.zip.raes.PromptingKeyManagerService;
import de.schlichtherle.truezip.fs.archive.zip.raes.SafeZipRaesDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyManager;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.key.spi.KeyManagerService;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.ServiceConfigurationError;

@DefaultAnnotation(value={NonNull.class})
public final class KeyManagement {
    private KeyManagement() {
    }

    public static void setPassword(TFile file, char[] password) {
        if (!file.isArchive()) {
            throw new IllegalArgumentException(file + " (not an archive file)");
        }
        AesCipherParameters params = new AesCipherParameters();
        params.setPassword(password);
        Arrays.fill(password, '\u0000');
        KeyManagerLocator.SINGLETON.get(AesCipherParameters.class).getKeyProvider(file.toFsPath().toHierarchicalUri()).setKey((Object)params);
    }

    public static void setAllPasswords1(char[] password) {
        TFile.setDefaultArchiveDetector((TArchiveDetector)new TArchiveDetector((FsDriverProvider)TArchiveDetector.ALL, "tzp|zip.rae|zip.raes", (FsDriver)new SafeZipRaesDriver((IOPoolProvider)IOPoolLocator.SINGLETON, (KeyManagerProvider)new PromptingKeyManagerService((PromptingKeyProvider.View)new SimpleView(password)))));
    }

    public static void setAllPasswords2(char[] password) {
        TFile.setDefaultArchiveDetector((TArchiveDetector)new TArchiveDetector((FsDriverProvider)TArchiveDetector.ALL, "tzp|zip.rae|zip.raes", (FsDriver)new SafeZipRaesDriver((IOPoolProvider)IOPoolLocator.SINGLETON, (KeyManagerProvider)new SimpleKeyManagerService(password))));
    }

    private static final class SimpleKeyProvider
    extends SafeKeyProvider<AesCipherParameters> {
        private AesCipherParameters key = new AesCipherParameters();

        SimpleKeyProvider(char[] password) {
            this.key.setPassword(password);
        }

        protected AesCipherParameters getWriteKeyImpl() {
            return this.key;
        }

        protected AesCipherParameters getReadKeyImpl(boolean invalid) {
            return this.key;
        }

        public void setKey(AesCipherParameters key) {
            this.key = key.clone();
        }
    }

    private static final class SimpleKeyProviderFactory
    implements KeyProvider.Factory<SimpleKeyProvider> {
        private final char[] password;

        SimpleKeyProviderFactory(char[] password) {
            this.password = (char[])password.clone();
        }

        public SimpleKeyProvider newKeyProvider() {
            return new SimpleKeyProvider(this.password);
        }
    }

    private static final class SimpleKeyManagerService
    extends KeyManagerService {
        private final KeyManager<AesCipherParameters> manager;

        SimpleKeyManagerService(char[] password) {
            this.manager = new SafeKeyManager((KeyProvider.Factory)new SimpleKeyProviderFactory(password));
        }

        public <K> KeyManager<K> get(Class<K> type) {
            if (type.equals(AesCipherParameters.class)) {
                return this.manager;
            }
            throw new ServiceConfigurationError("No key manager available for " + type);
        }
    }

    private static final class SimpleView
    implements PromptingKeyProvider.View<AesCipherParameters> {
        private final AesCipherParameters params = new AesCipherParameters();

        public SimpleView(char[] password) {
            if (null == password) {
                throw new NullPointerException();
            }
            this.params.setPassword(password);
        }

        public void promptWriteKey(PromptingKeyProvider.Controller<AesCipherParameters> controller) {
            controller.setKey((SafeKey)this.params);
        }

        public void promptReadKey(PromptingKeyProvider.Controller<AesCipherParameters> controller, boolean invalid) {
            controller.setKey((SafeKey)this.params);
        }
    }
}

