/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file.app;

import de.schlichtherle.truezip.crypto.raes.param.swing.HurlingWindowFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.file.TApplication;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.OutputStream;
import java.io.PrintStream;

@DefaultAnnotation(value={NonNull.class})
abstract class Application
extends TApplication<RuntimeException> {
    protected final PrintStream out;
    protected final PrintStream err;

    protected Application() {
        this(System.out, System.err, true);
    }

    protected Application(OutputStream out, OutputStream err, boolean autoFlush) {
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, autoFlush);
        this.err = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err, autoFlush);
    }

    protected void setup() {
        String spec = InvalidKeyFeedback.class.getName();
        String impl = HurlingWindowFeedback.class.getName();
        System.setProperty(spec, System.getProperty(spec, impl));
    }

    protected final int work(String[] args) {
        try {
            return this.runChecked(args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.err.println(ex.getLocalizedMessage());
            return 1;
        }
    }

    protected abstract int runChecked(String[] var1) throws Exception;

    protected static class IllegalUsageException
    extends Exception {
        private static final long serialVersionUID = 1985623981423542464L;

        protected IllegalUsageException(String msg) {
            super(msg);
        }
    }
}

